/*
 * Decompiled with CFR 0.152.
 */
package fiji.packaging;

import fiji.packaging.Packager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipPackager
extends Packager {
    protected Set<String> executables = new HashSet<String>();
    protected MarkExecutableOutputStream out;
    protected ZipOutputStream zip;

    @Override
    public String getExtension() {
        return ".zip";
    }

    @Override
    public void open(OutputStream out) {
        this.out = new MarkExecutableOutputStream(out);
        this.zip = new ZipOutputStream(this.out);
    }

    @Override
    public void putNextEntry(String name, boolean executable, int size) throws IOException {
        if (executable) {
            this.executables.add(name);
        }
        this.zip.putNextEntry(new ZipEntry(name));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.zip.write(b, off, len);
    }

    @Override
    public void closeEntry() throws IOException {
        this.zip.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.out.tocStartsNow();
        this.zip.close();
    }

    private class MarkExecutableOutputStream
    extends OutputStream {
        protected OutputStream out;
        protected byte[] tocEntry;
        protected int tocEntryOffset;
        protected int tocEntryLen;
        protected static final int BASE_ENTRY_LENGTH = 46;

        public MarkExecutableOutputStream(OutputStream out) {
            this.out = out;
            this.tocEntry = null;
            this.tocEntryLen = 0;
            this.tocEntryOffset = 0;
        }

        public void tocStartsNow() {
            this.tocEntry = new byte[1070];
            this.tocEntryLen = 0;
            this.tocEntryOffset = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.tocEntry == null) {
                this.out.write(b);
            } else {
                this.tocEntry[this.tocEntryOffset++] = (byte)b;
                this.handleTOCEntry();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.tocEntry == null) {
                this.out.write(b);
            } else {
                this.write(b, 0, b.length);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.tocEntry == null) {
                this.out.write(b, off, len);
            } else {
                System.arraycopy(b, off, this.tocEntry, this.tocEntryOffset, len);
                this.tocEntryOffset += len;
                this.handleTOCEntry();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.tocEntry == null) {
                throw new IOException("Did not write TOC correctly!");
            }
            if (this.tocEntryOffset > 0) {
                if (this.getU16(0) == 19280 && this.getU16(2) == 1541) {
                    this.out.write(this.tocEntry, 0, this.tocEntryOffset);
                } else {
                    throw new IOException("Incomplete TOC!");
                }
            }
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        protected void handleTOCEntry() throws IOException {
            if (this.tocEntryLen == 0) {
                if (this.tocEntryOffset >= 46) {
                    if (this.getU16(0) != 19280 || this.getU16(2) != 513) {
                        return;
                    }
                    this.tocEntryLen = 46 + this.getFileNameLength() + this.getU16(30) + this.getU16(32);
                    if (this.tocEntryLen > this.tocEntry.length) {
                        throw new IOException("ZIP entry too long!");
                    }
                }
            } else if (this.tocEntryOffset >= this.tocEntryLen) {
                String fileName = this.getFileName();
                if (ZipPackager.this.executables.contains(fileName)) {
                    int fileMode = 33261;
                    this.tocEntry[40] = (byte)(fileMode & 0xFF);
                    this.tocEntry[41] = (byte)(fileMode >> 8 & 0xFF);
                    this.tocEntry[5] = 3;
                }
                this.out.write(this.tocEntry, 0, this.tocEntryLen);
                this.tocEntryOffset -= this.tocEntryLen;
                if (this.tocEntryOffset > 0) {
                    throw new IOException("Unaligned TOC entry!");
                }
                this.tocEntryLen = 0;
            }
        }

        protected String getFileName() {
            return new String(this.tocEntry, 46, this.getFileNameLength());
        }

        protected int getFileNameLength() {
            return this.getU16(28);
        }

        protected int getU16(int offset) {
            return this.tocEntry[offset] & 0xFF | (this.tocEntry[offset + 1] & 0xFF) << 8;
        }
    }
}

