/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExitAction
extends AbstractApplicationAction {
    public static final String ID = "application.exit";
    private Component oldFocusOwner;
    private View unsavedView;

    public ExitAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final Application app = this.getApplication();
        if (app.isEnabled()) {
            app.setEnabled(false);
            int unsavedViewsCount = 0;
            View documentToBeReviewed = null;
            URI unsavedURI = null;
            for (View p : app.views()) {
                if (!p.hasUnsavedChanges()) continue;
                if (p.isEnabled()) {
                    documentToBeReviewed = p;
                }
                unsavedURI = p.getURI();
                ++unsavedViewsCount;
            }
            if (unsavedViewsCount > 0 && documentToBeReviewed == null) {
                app.setEnabled(true);
                return;
            }
            final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            switch (unsavedViewsCount) {
                case 0: {
                    this.doExit();
                    break;
                }
                case 1: {
                    this.unsavedView = documentToBeReviewed;
                    this.oldFocusOwner = SwingUtilities.getWindowAncestor(this.unsavedView.getComponent()).getFocusOwner();
                    this.unsavedView.setEnabled(false);
                    JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("application.exit.doYouWantToSave.message", unsavedURI == null ? labels.getString("unnamedFile") : URIUtil.getName(unsavedURI)) + "</b><p>" + labels.getString("application.exit.doYouWantToSave.details"), 2);
                    Object[] options = new Object[]{labels.getString("application.exit.saveOption"), labels.getString("application.exit.cancelOption"), labels.getString("application.exit.dontSaveOption")};
                    pane.setOptions(options);
                    pane.setInitialValue(options[0]);
                    pane.putClientProperty("Quaqua.OptionPane.destructiveOption", 2);
                    JSheet.showSheet(pane, this.unsavedView.getComponent(), new SheetListener(){

                        @Override
                        public void optionSelected(SheetEvent evt) {
                            Object value = evt.getValue();
                            if (value == null || value.equals(labels.getString("application.exit.cancelOption"))) {
                                ExitAction.this.unsavedView.setEnabled(true);
                                app.setEnabled(true);
                            } else if (value.equals(labels.getString("application.exit.dontSaveOption"))) {
                                ExitAction.this.doExit();
                                ExitAction.this.unsavedView.setEnabled(true);
                            } else if (value.equals(labels.getString("application.exit.saveOption"))) {
                                ExitAction.this.saveChanges();
                            }
                        }
                    });
                    break;
                }
                default: {
                    JOptionPane pane = new JOptionPane("<html>" + UIManager.get("OptionPane.css") + "<b>" + labels.getFormatted("application.exit.doYouWantToReview.message", unsavedViewsCount) + "</b><p>" + labels.getString("application.exit.doYouWantToReview.details"), 3);
                    Object[] options = new Object[]{labels.getString("application.exit.reviewChangesOption"), labels.getString("application.exit.cancelOption"), labels.getString("application.exit.discardChangesOption")};
                    pane.setOptions(options);
                    pane.setInitialValue(options[0]);
                    pane.putClientProperty("Quaqua.OptionPane.destructiveOption", 2);
                    JDialog dialog = pane.createDialog(app.getComponent(), null);
                    Rectangle screenBounds = dialog.getGraphicsConfiguration().getBounds();
                    if (app.getComponent() == null || !screenBounds.contains(app.getComponent().getBounds())) {
                        dialog.setLocation((screenBounds.width - dialog.getWidth()) / 2, (screenBounds.height - dialog.getHeight()) / 3);
                    }
                    dialog.setVisible(true);
                    Object value = pane.getValue();
                    if (value == null || value.equals(labels.getString("application.exit.cancelOption"))) {
                        app.setEnabled(true);
                        break;
                    }
                    if (value.equals(labels.getString("application.exit.discardChangesOption"))) {
                        this.doExit();
                        app.setEnabled(true);
                        break;
                    }
                    if (!value.equals(labels.getString("application.exit.reviewChangesOption"))) break;
                    this.unsavedView = documentToBeReviewed;
                    this.reviewChanges();
                }
            }
        }
    }

    protected URIChooser getChooser(View view) {
        URIChooser chsr = (URIChooser)view.getComponent().getClientProperty("saveChooser");
        if (chsr == null) {
            chsr = this.getApplication().getModel().createSaveChooser(this.getApplication(), view);
            view.getComponent().putClientProperty("saveChooser", chsr);
        }
        return chsr;
    }

    protected void saveChanges() {
        View v = this.unsavedView;
        if (v.getURI() == null) {
            URIChooser chooser = this.getChooser(v);
            JSheet.showSaveSheet(chooser, (Component)v.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        URI uri = evt.getChooser().getSelectedURI();
                        ExitAction.this.saveToFile(uri, evt.getChooser());
                    } else {
                        ExitAction.this.unsavedView.setEnabled(true);
                        if (ExitAction.this.oldFocusOwner != null) {
                            ExitAction.this.oldFocusOwner.requestFocus();
                        }
                        ExitAction.this.getApplication().setEnabled(true);
                    }
                }
            });
        } else {
            this.saveToFile(v.getURI(), null);
        }
    }

    protected void reviewChanges() {
        if (this.unsavedView.isEnabled()) {
            final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(this.unsavedView.getComponent()).getFocusOwner();
            this.unsavedView.setEnabled(false);
            URI unsavedURI = this.unsavedView.getURI();
            JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + labels.getFormatted("application.exit.doYouWantToSave.message", unsavedURI == null ? this.unsavedView.getTitle() : URIUtil.getName(unsavedURI)), 2);
            Object[] options = new Object[]{labels.getString("application.exit.saveOption"), labels.getString("application.exit.cancelOption"), labels.getString("application.exit.dontSaveOption")};
            pane.setOptions(options);
            pane.setInitialValue(options[0]);
            pane.putClientProperty("Quaqua.OptionPane.destructiveOption", 2);
            JSheet.showSheet(pane, this.unsavedView.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    Object value = evt.getValue();
                    if (value == null || value.equals(labels.getString("application.exit.cancelOption"))) {
                        ExitAction.this.unsavedView.setEnabled(true);
                        ExitAction.this.getApplication().setEnabled(true);
                    } else if (value.equals(labels.getString("application.exit.dontSaveOption"))) {
                        ExitAction.this.getApplication().dispose(ExitAction.this.unsavedView);
                        ExitAction.this.reviewNext();
                    } else if (value.equals(labels.getString("application.exit.saveOption"))) {
                        ExitAction.this.saveChangesAndReviewNext();
                    }
                }
            });
        } else {
            this.getApplication().setEnabled(true);
        }
    }

    protected void saveChangesAndReviewNext() {
        final View v = this.unsavedView;
        if (v.getURI() == null) {
            URIChooser chooser = this.getChooser(v);
            JSheet.showSaveSheet(chooser, (Component)this.unsavedView.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        URI uri = evt.getChooser().getSelectedURI();
                        ExitAction.this.saveToFileAndReviewNext(uri, evt.getChooser());
                    } else {
                        v.setEnabled(true);
                        if (ExitAction.this.oldFocusOwner != null) {
                            ExitAction.this.oldFocusOwner.requestFocus();
                        }
                        ExitAction.this.getApplication().setEnabled(true);
                    }
                }
            });
        } else {
            this.saveToFileAndReviewNext(v.getURI(), null);
        }
    }

    protected void reviewNext() {
        int unsavedViewsCount = 0;
        View documentToBeReviewed = null;
        for (View p : this.getApplication().views()) {
            if (!p.hasUnsavedChanges()) continue;
            if (p.isEnabled()) {
                documentToBeReviewed = p;
            }
            ++unsavedViewsCount;
        }
        if (unsavedViewsCount == 0) {
            this.doExit();
        } else if (documentToBeReviewed != null) {
            this.unsavedView = documentToBeReviewed;
            this.reviewChanges();
        } else {
            this.getApplication().setEnabled(true);
        }
    }

    protected void saveToFile(final URI uri, final @Nullable URIChooser chooser) {
        final View v = this.unsavedView;
        v.execute(new Worker(){

            protected Object construct() throws IOException {
                v.write(uri, chooser);
                return null;
            }

            protected void done(Object value) {
                v.setURI(uri);
                ExitAction.this.doExit();
            }

            @Override
            protected void failed(Throwable error) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet((Component)v.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.format("file.save.couldntSave.message", URIUtil.getName(uri)) + "</b><p>" + error), 0);
            }

            @Override
            public void finished() {
                v.setEnabled(true);
                if (ExitAction.this.oldFocusOwner != null) {
                    ExitAction.this.oldFocusOwner.requestFocus();
                }
                ExitAction.this.getApplication().setEnabled(true);
            }
        });
    }

    protected void saveToFileAndReviewNext(final URI uri, final @Nullable URIChooser chooser) {
        final View v = this.unsavedView;
        v.execute(new Worker(){

            protected Object construct() throws IOException {
                v.write(uri, chooser);
                return null;
            }

            protected void done(Object value) {
                v.setURI(uri);
                ExitAction.this.getApplication().dispose(ExitAction.this.unsavedView);
                ExitAction.this.reviewNext();
            }

            @Override
            protected void failed(Throwable error) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet((Component)v.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.format("file.save.couldntSave.message", uri) + "</b><p>" + error), 0);
                v.setEnabled(true);
                if (ExitAction.this.oldFocusOwner != null) {
                    ExitAction.this.oldFocusOwner.requestFocus();
                }
                ExitAction.this.getApplication().setEnabled(true);
            }
        });
    }

    protected void doExit() {
        this.getApplication().destroy();
    }
}

