/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.app;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.PrintableView;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.file.PrintFileAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;

public class PrintApplicationFileAction
extends PrintFileAction {
    public static final String ID = "application.printFile";
    private JFileChooser fileChooser;
    private int entries;

    public PrintApplicationFileAction(Application app) {
        super(app, null);
        this.putValue("Name", "OSX Print File");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final Application app = this.getApplication();
        final String filename = evt.getActionCommand();
        View v = app.createView();
        if (!(v instanceof PrintableView)) {
            return;
        }
        final PrintableView p = (PrintableView)v;
        p.setEnabled(false);
        app.add(p);
        p.execute(new Worker(){

            public Object construct() throws IOException {
                p.read(new File(filename).toURI(), null);
                return null;
            }

            protected void done(Object value) {
                p.setURI(new File(filename).toURI());
                p.setEnabled(false);
                if (System.getProperty("apple.awt.graphics.UseQuartz", "false").equals("true")) {
                    PrintApplicationFileAction.this.printQuartz(p);
                } else {
                    PrintApplicationFileAction.this.printJava2D(p);
                }
                p.setEnabled(true);
                app.dispose(p);
            }

            @Override
            protected void failed(Throwable value) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                app.dispose(p);
                JOptionPane.showMessageDialog(null, "<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.open.couldntOpen.message", new File(filename).getName()) + "</b><p>" + value, "", 0);
            }
        });
    }
}

