/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.color.ColorSpace;
import org.jhotdraw.color.NamedColorSpace;

public class CMYKNominalColorSpace
extends ColorSpace
implements NamedColorSpace {
    private static CMYKNominalColorSpace instance;

    public static CMYKNominalColorSpace getInstance() {
        if (instance == null) {
            instance = new CMYKNominalColorSpace();
        }
        return instance;
    }

    public CMYKNominalColorSpace() {
        super(9, 4);
    }

    @Override
    public float[] toRGB(float[] component) {
        float cyan = component[0];
        float magenta = component[1];
        float yellow = component[2];
        float black = component[3];
        float red = 1.0f - cyan * (1.0f - black) - black;
        float green = 1.0f - magenta * (1.0f - black) - black;
        float blue = 1.0f - yellow * (1.0f - black) - black;
        red = Math.min(1.0f, Math.max(0.0f, red));
        green = Math.min(1.0f, Math.max(0.0f, green));
        blue = Math.min(1.0f, Math.max(0.0f, blue));
        return new float[]{red, green, blue};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float black;
        float r = rgbvalue[0];
        float g = rgbvalue[1];
        float b = rgbvalue[2];
        float cyan = 1.0f - r;
        float magenta = 1.0f - g;
        float yellow = 1.0f - b;
        if (Math.min(Math.min(cyan, magenta), yellow) >= 1.0f) {
            yellow = 0.0f;
            magenta = 0.0f;
            cyan = 0.0f;
            black = 1.0f;
        } else {
            black = Math.min(Math.min(cyan, magenta), yellow);
            if (black > 0.0f) {
                cyan = (cyan - black) / (1.0f - black);
                magenta = (magenta - black) / (1.0f - black);
                yellow = (yellow - black) / (1.0f - black);
            }
        }
        cyan = Math.min(1.0f, Math.max(0.0f, cyan));
        yellow = Math.min(1.0f, Math.max(0.0f, yellow));
        magenta = Math.min(1.0f, Math.max(0.0f, magenta));
        black = Math.min(1.0f, Math.max(0.0f, black));
        return new float[]{cyan, magenta, yellow, black};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] rgb = this.toRGB(colorvalue);
        return ColorSpace.getInstance(1000).toCIEXYZ(rgb);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] sRGB = ColorSpace.getInstance(1000).fromCIEXYZ(colorvalue);
        return this.fromRGB(sRGB);
    }

    @Override
    public String getName(int idx) {
        switch (idx) {
            case 0: {
                return "Cyan";
            }
            case 1: {
                return "Magenta";
            }
            case 2: {
                return "Yellow";
            }
            case 3: {
                return "Black";
            }
        }
        throw new IllegalArgumentException("index must be between 0 and 3:" + idx);
    }

    @Override
    public float getMaxValue(int component) {
        return 1.0f;
    }

    @Override
    public float getMinValue(int component) {
        return 0.0f;
    }

    public boolean equals(Object o) {
        return o instanceof CMYKNominalColorSpace;
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode();
    }

    @Override
    public String getName() {
        return "nominal CMYK";
    }
}

