/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeKey<T>
implements Serializable {
    private String key;
    @Nullable
    private T defaultValue;
    private boolean isNullValueAllowed;
    private ResourceBundleUtil labels;
    private Class<T> clazz;

    public AttributeKey(String key, Class<T> clazz) {
        this(key, clazz, null, true);
    }

    public AttributeKey(String key, Class<T> clazz, @Nullable T defaultValue) {
        this(key, clazz, defaultValue, true);
    }

    public AttributeKey(String key, Class<T> clazz, @Nullable T defaultValue, boolean isNullValueAllowed) {
        this(key, clazz, defaultValue, isNullValueAllowed, null);
    }

    public AttributeKey(String key, Class<T> clazz, @Nullable T defaultValue, boolean isNullValueAllowed, @Nullable ResourceBundleUtil labels) {
        this.key = key;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.isNullValueAllowed = isNullValueAllowed;
        this.labels = labels == null ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels") : labels;
    }

    public String getKey() {
        return this.key;
    }

    public String getPresentationName() {
        return this.labels == null ? this.key : this.labels.getString("attribute." + this.key + ".text");
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public T getClone(Figure f) {
        Object value = f.get(this);
        try {
            return value == null ? null : (T)this.clazz.cast(Methods.invoke(value, "clone"));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    @Nullable
    public T get(Figure f) {
        return f.get(this);
    }

    @Nullable
    public T get(Map<AttributeKey, Object> a) {
        return (T)(a.containsKey(this) ? a.get(this) : this.defaultValue);
    }

    public void set(Figure f, @Nullable T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        f.set(this, value);
    }

    public UndoableEdit setUndoable(final Figure f, final @Nullable T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        final Object restoreData = f.getAttributesRestoreData();
        f.set(this, value);
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return AttributeKey.this.getPresentationName();
            }

            @Override
            public void undo() {
                super.undo();
                f.willChange();
                f.restoreAttributesTo(restoreData);
                f.changed();
            }

            @Override
            public void redo() {
                super.redo();
                f.willChange();
                f.set(AttributeKey.this, value);
                f.changed();
            }
        };
        return edit;
    }

    public void setClone(Figure f, @Nullable T value) {
        try {
            f.set(this, value == null ? null : (Object)this.clazz.cast(Methods.invoke(value, "clone")));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public void putClone(Map<AttributeKey, Object> a, @Nullable T value) {
        try {
            this.put(a, value == null ? null : (T)this.clazz.cast(Methods.invoke(value, "clone")));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    @Nullable
    public T put(Map<AttributeKey, Object> a, @Nullable T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        return (T)a.put(this, value);
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public boolean isAssignable(@Nullable Object value) {
        if (value == null) {
            return this.isNullValueAllowed();
        }
        return this.clazz.isInstance(value);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof AttributeKey) {
            return ((AttributeKey)that).key.equals(this.key);
        }
        return false;
    }
}

