/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class ApplyAttributesAction
extends AbstractSelectedAction {
    private Set<AttributeKey> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public ApplyAttributesAction(DrawingEditor editor) {
        super(editor);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        labels.configureAction(this, "edit.applyAttributes");
        this.updateEnabledState();
    }

    public void setExcludedAttributes(Set<AttributeKey> a) {
        this.excludedAttributes = a;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.applyAttributes();
    }

    public void applyAttributes() {
        DrawingEditor editor = this.getEditor();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        CompositeEdit edit = new CompositeEdit(labels.getString("edit.applyAttributes.text"));
        DrawingView view = this.getView();
        view.getDrawing().fireUndoableEditHappened(edit);
        for (Figure figure : view.getSelectedFigures()) {
            figure.willChange();
            for (Map.Entry<AttributeKey, Object> entry : editor.getDefaultAttributes().entrySet()) {
                if (this.excludedAttributes.contains(entry.getKey())) continue;
                figure.set(entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        view.getDrawing().fireUndoableEditHappened(edit);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

