/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.handle;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.event.TransformRestoreEdit;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.geom.Geom;

public class BezierScaleHandle
extends AbstractHandle {
    @Nullable
    private Point location;
    private Object restoreData;
    private AffineTransform transform;
    private Point2D.Double center;
    private double startTheta;
    private double startLength;

    public BezierScaleHandle(BezierFigure owner) {
        super(owner);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        return false;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.SCALE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.SCALE_HANDLE_STROKE_COLOR));
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.view.drawingToView(this.getOrigin());
        }
        return this.location;
    }

    private BezierFigure getBezierFigure() {
        return (BezierFigure)this.getOwner();
    }

    private Point2D.Double getOrigin() {
        int handlesize = this.getHandlesize();
        Point2D.Double outer = this.getBezierFigure().getOutermostPoint();
        Point2D.Double ctr = this.getBezierFigure().getCenter();
        double len = Geom.length(outer.x, outer.y, ctr.x, ctr.y);
        if (len == 0.0) {
            return new Point2D.Double(outer.x - (double)(handlesize / 2), outer.y + (double)(handlesize / 2));
        }
        double u = (double)handlesize / len;
        if (u > 1.0) {
            return new Point2D.Double((outer.x * 3.0 + ctr.x) / 4.0, (outer.y * 3.0 + ctr.y) / 4.0);
        }
        return new Point2D.Double(outer.x * (1.0 - u) + ctr.x * u, outer.y * (1.0 - u) + ctr.y * u);
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.location = new Point(anchor.x, anchor.y);
        this.restoreData = this.getBezierFigure().getTransformRestoreData();
        this.transform = new AffineTransform();
        this.center = this.getBezierFigure().getCenter();
        Point2D.Double anchorPoint = this.view.viewToDrawing(anchor);
        this.startTheta = Geom.angle(this.center.x, this.center.y, anchorPoint.x, anchorPoint.y);
        this.startLength = Geom.length(this.center.x, this.center.y, anchorPoint.x, anchorPoint.y);
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        this.location = new Point(lead.x, lead.y);
        Point2D.Double leadPoint = this.view.viewToDrawing(lead);
        double stepTheta = Geom.angle(this.center.x, this.center.y, leadPoint.x, leadPoint.y);
        double stepLength = Geom.length(this.center.x, this.center.y, leadPoint.x, leadPoint.y);
        double scaleFactor = (modifiersEx & 0x240) != 0 ? 1.0 : stepLength / this.startLength;
        this.transform.setToIdentity();
        this.transform.translate(this.center.x, this.center.y);
        this.transform.scale(scaleFactor, scaleFactor);
        this.transform.rotate(stepTheta - this.startTheta);
        this.transform.translate(-this.center.x, -this.center.y);
        this.getOwner().willChange();
        this.getOwner().restoreTransformTo(this.restoreData);
        this.getOwner().transform(this.transform);
        this.getOwner().changed();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        this.view.getDrawing().fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), this.restoreData, this.getOwner().getTransformRestoreData()));
        this.location = null;
    }
}

