/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.layouter;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.layouter.AbstractLayouter;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2D;

public class VerticalLayouter
extends AbstractLayouter {
    private AttributeKeys.Alignment defaultAlignment = AttributeKeys.Alignment.BLOCK;

    @Override
    public Rectangle2D.Double calculateLayout(CompositeFigure layoutable, Point2D.Double anchor, Point2D.Double lead) {
        Insets2D.Double layoutInsets = layoutable.get(AttributeKeys.LAYOUT_INSETS);
        if (layoutInsets == null) {
            layoutInsets = new Insets2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        Rectangle2D.Double layoutBounds = new Rectangle2D.Double(anchor.x, anchor.y, 0.0, 0.0);
        for (Figure child : layoutable.getChildren()) {
            if (!child.isVisible()) continue;
            Dimension2DDouble preferredSize = child.getPreferredSize();
            Insets2D.Double ins = this.getInsets(child);
            layoutBounds.width = Math.max(layoutBounds.width, preferredSize.width + ins.left + ins.right);
            layoutBounds.height += preferredSize.height + ins.top + ins.bottom;
        }
        layoutBounds.width += layoutInsets.left + layoutInsets.right;
        layoutBounds.height += layoutInsets.top + layoutInsets.bottom;
        return layoutBounds;
    }

    @Override
    public Rectangle2D.Double layout(CompositeFigure layoutable, Point2D.Double anchor, Point2D.Double lead) {
        Insets2D.Double layoutInsets = layoutable.get(AttributeKeys.LAYOUT_INSETS);
        AttributeKeys.Alignment compositeAlignment = layoutable.get(AttributeKeys.COMPOSITE_ALIGNMENT);
        if (layoutInsets == null) {
            layoutInsets = new Insets2D.Double();
        }
        Rectangle2D.Double layoutBounds = this.calculateLayout(layoutable, anchor, lead);
        double y = layoutBounds.y + layoutInsets.top;
        for (Figure child : layoutable.getChildren()) {
            if (!child.isVisible()) continue;
            Insets2D.Double insets = this.getInsets(child);
            double height = child.getPreferredSize().height;
            double width = child.getPreferredSize().width;
            switch (compositeAlignment) {
                case LEADING: {
                    child.setBounds(new Point2D.Double(layoutBounds.x + layoutInsets.left + insets.left, y + insets.top), new Point2D.Double(layoutBounds.x + layoutInsets.left + insets.left + width, y + insets.top + height));
                    break;
                }
                case TRAILING: {
                    child.setBounds(new Point2D.Double(layoutBounds.x + layoutBounds.width - layoutInsets.right - insets.right - width, y + insets.top), new Point2D.Double(layoutBounds.x + layoutBounds.width - layoutInsets.right - insets.right, y + insets.top + height));
                    break;
                }
                case CENTER: {
                    child.setBounds(new Point2D.Double(layoutBounds.x + (layoutBounds.width - width) / 2.0, y + insets.top), new Point2D.Double(layoutBounds.x + (layoutBounds.width + width) / 2.0, y + insets.top + height));
                    break;
                }
                default: {
                    child.setBounds(new Point2D.Double(layoutBounds.x + layoutInsets.left + insets.left, y + insets.top), new Point2D.Double(layoutBounds.x + layoutBounds.width - layoutInsets.right - insets.right, y + insets.top + height));
                }
            }
            y += height + insets.top + insets.bottom;
        }
        return layoutBounds;
    }
}

