/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.locator;

import java.awt.geom.Point2D;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.locator.AbstractLocator;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class BezierPointLocator
extends AbstractLocator {
    private int index;
    private int coord;

    public BezierPointLocator(int index) {
        this.index = index;
        this.coord = 0;
    }

    public BezierPointLocator(int index, int coord) {
        this.index = index;
        this.coord = index;
    }

    @Override
    public Point2D.Double locate(Figure owner) {
        BezierFigure plf = (BezierFigure)owner;
        if (this.index < plf.getNodeCount()) {
            return plf.getPoint(this.index, this.coord);
        }
        return new Point2D.Double(0.0, 0.0);
    }

    @Override
    public void write(DOMOutput out) {
        out.addAttribute("index", this.index, 0);
        out.addAttribute("coord", this.coord, 0);
    }

    @Override
    public void read(DOMInput in) {
        this.index = in.getAttribute("index", 0);
        this.coord = in.getAttribute("coord", 0);
    }
}

