/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.colorchooser.PaletteColorChooserMainPanel;
import org.jhotdraw.gui.plaf.palette.colorchooser.PaletteColorChooserPreviewPanel;

public class PaletteColorChooserUI
extends ColorChooserUI {
    @Nullable
    protected PaletteColorChooserMainPanel mainPanel;
    @Nullable
    protected JColorChooser chooser;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    @Nullable
    protected AbstractColorChooserPanel[] defaultChoosers;
    @Nullable
    protected JComponent previewPanel;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    private MouseListener previewMouseListener;

    public static ComponentUI createUI(JComponent c) {
        return new PaletteColorChooserUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.chooser = (JColorChooser)c;
        AbstractColorChooserPanel[] oldPanels = this.chooser.getChooserPanels();
        this.installDefaults();
        this.chooser.setLayout(new BorderLayout());
        this.mainPanel = new PaletteColorChooserMainPanel();
        this.chooser.add(this.mainPanel);
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
        AbstractColorChooserPanel[] newPanels = this.chooser.getChooserPanels();
        this.updateColorChooserPanels(oldPanels, newPanels);
        this.installListeners();
        this.chooser.applyComponentOrientation(c.getComponentOrientation());
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String[] defaultChooserNames = (String[])PaletteLookAndFeel.getInstance().get("ColorChooser.defaultChoosers");
        ArrayList<AbstractColorChooserPanel> panels = new ArrayList<AbstractColorChooserPanel>(defaultChooserNames.length);
        for (int i = 0; i < defaultChooserNames.length; ++i) {
            try {
                panels.add((AbstractColorChooserPanel)Class.forName(defaultChooserNames[i]).newInstance());
                continue;
            }
            catch (AccessControlException e) {
                System.err.println("PaletteColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                System.err.println("PaletteColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
                e.printStackTrace();
                continue;
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("PaletteColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
                continue;
            }
            catch (Throwable t) {
                System.err.println("PaletteColorChooserUI warning: unable to instantiate " + defaultChooserNames[i]);
            }
        }
        return panels.toArray(new AbstractColorChooserPanel[panels.size()]);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.chooser.remove(this.mainPanel);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.mainPanel.setPreviewPanel(null);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.mainPanel = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void installDefaults() {
        PaletteLookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        TransferHandler th = this.chooser.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
        this.previewMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PaletteColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler th = PaletteColorChooserUI.this.chooser.getTransferHandler();
                    th.exportAsDrag(PaletteColorChooserUI.this.chooser, e, 1);
                }
            }
        };
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanel.removeMouseListener(this.previewMouseListener);
        }
        if (this.previewPanel != null) {
            this.mainPanel.setPreviewPanel(null);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && this.mainPanel != null && this.previewPanel.getSize().getHeight() + this.previewPanel.getSize().getWidth() == 0.0) {
            this.mainPanel.setPreviewPanel(null);
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = new PaletteColorChooserPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.mainPanel.setPreviewPanel(this.previewPanel);
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    private void updateColorChooserPanels(AbstractColorChooserPanel[] oldPanels, AbstractColorChooserPanel[] newPanels) {
        int i;
        for (i = 0; i < oldPanels.length; ++i) {
            Container wrapper = oldPanels[i].getParent();
            if (wrapper == null) continue;
            Container parent = wrapper.getParent();
            if (parent != null) {
                parent.remove(wrapper);
            }
            oldPanels[i].uninstallChooserPanel(this.chooser);
        }
        this.mainPanel.removeAllColorChooserPanels();
        for (i = 0; i < newPanels.length; ++i) {
            if (newPanels[i] == null) continue;
            this.mainPanel.addColorChooserPanel(newPanels[i]);
        }
        for (i = 0; i < newPanels.length; ++i) {
            if (newPanels[i] == null) continue;
            newPanels[i].installChooserPanel(this.chooser);
        }
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("chooserPanels")) {
                int i;
                AbstractColorChooserPanel[] oldPanels = (AbstractColorChooserPanel[])e.getOldValue();
                AbstractColorChooserPanel[] newPanels = (AbstractColorChooserPanel[])e.getNewValue();
                for (i = 0; i < oldPanels.length; ++i) {
                    Container wrapper;
                    if (oldPanels[i] == null || (wrapper = oldPanels[i].getParent()) == null) continue;
                    Container parent = wrapper.getParent();
                    if (parent != null) {
                        parent.remove(wrapper);
                    }
                    oldPanels[i].uninstallChooserPanel(PaletteColorChooserUI.this.chooser);
                }
                PaletteColorChooserUI.this.mainPanel.removeAllColorChooserPanels();
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    PaletteColorChooserUI.this.mainPanel.addColorChooserPanel(newPanels[i]);
                }
                PaletteColorChooserUI.this.chooser.applyComponentOrientation(PaletteColorChooserUI.this.chooser.getComponentOrientation());
                for (i = 0; i < newPanels.length; ++i) {
                    if (newPanels[i] == null) continue;
                    newPanels[i].installChooserPanel(PaletteColorChooserUI.this.chooser);
                }
            }
            if (name.equals("previewPanel") && e.getNewValue() != PaletteColorChooserUI.this.previewPanel) {
                PaletteColorChooserUI.this.installPreviewPanel();
            }
            if (name.equals("componentOrientation")) {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JColorChooser cc = (JColorChooser)e.getSource();
                if (o != (ComponentOrientation)e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                    cc.updateUI();
                }
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorSelectionModel model = (ColorSelectionModel)e.getSource();
            if (PaletteColorChooserUI.this.previewPanel != null) {
                PaletteColorChooserUI.this.previewPanel.setForeground(model.getSelectedColor());
                PaletteColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

