/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.samples.teddy.CharacterSetAccessory;
import org.jhotdraw.samples.teddy.FindDialog;
import org.jhotdraw.samples.teddy.io.LFWriter;
import org.jhotdraw.samples.teddy.regex.Matcher;
import org.jhotdraw.samples.teddy.text.NumberedEditorKit;
import org.jhotdraw.samples.teddy.text.NumberedViewFactory;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class TeddyView
extends AbstractView {
    private static Preferences prefs = PreferencesUtil.userNodeForPackage(TeddyView.class);
    protected JTextPane editor;
    protected EditorPanel editorViewport;
    protected UndoRedoManager undoManager;
    private FindDialog findDialog;
    private Matcher matcher;
    public JLabel caretInfoLabel;
    public JScrollPane scrollPane;
    public JPanel statusBar;

    public TeddyView() {
        prefs = PreferencesUtil.userNodeForPackage(TeddyView.class);
        this.initComponents();
        this.statusBar.setVisible(prefs.getBoolean("statusBarVisible", false));
        this.editor = this.createEditor();
        this.editorViewport = new EditorPanel();
        this.editorViewport.setEditor(this.editor);
        this.editorViewport.setLineWrap(prefs.getBoolean("lineWrap", true));
        this.scrollPane.setViewportView(this.editorViewport);
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TeddyView.this.caretUpdate(evt);
            }
        });
        this.scrollPane.getViewport().setBackground(this.editor.getBackground());
        this.scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TeddyView.this.editor.requestFocus();
            }
        });
        Font font = this.getFont();
        MutableAttributeSet attrs = ((StyledEditorKit)this.editor.getEditorKit()).getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        NumberedEditorKit editorKit = new NumberedEditorKit();
        ((NumberedViewFactory)editorKit.getViewFactory()).setLineNumbersVisible(prefs.getBoolean("lineNumbersVisible", false));
        this.editor.setEditorKit(editorKit);
        this.editor.setDocument(this.createDocument());
        this.setPreferredSize(new Dimension(400, 400));
        this.undoManager = new UndoRedoManager();
        this.editor.getDocument().addUndoableEditListener(this.undoManager);
        this.undoManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TeddyView.this.setHasUnsavedChanges(TeddyView.this.undoManager.hasSignificantEdits());
            }
        });
    }

    protected JTextPane createEditor() {
        return new JTextPane();
    }

    @Override
    public void init() {
        this.initActions();
    }

    @Override
    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.editor.setEnabled(newValue);
        this.scrollPane.setEnabled(newValue);
    }

    public void setStatusBarVisible(boolean newValue) {
        boolean oldValue = this.statusBar.isVisible();
        this.statusBar.setVisible(newValue);
        prefs.putBoolean("statusBarVisible", newValue);
        this.firePropertyChange("statusBarVisible", oldValue, newValue);
    }

    public boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public void setLineWrap(boolean newValue) {
        boolean oldValue = this.editorViewport.getLineWrap();
        this.editorViewport.setLineWrap(newValue);
        prefs.putBoolean("lineWrap", newValue);
        this.firePropertyChange("lineWrap", oldValue, newValue);
    }

    public boolean isLineWrap() {
        return this.editorViewport.getLineWrap();
    }

    private void initActions() {
        this.getActionMap().put("edit.undo", this.undoManager.getUndoAction());
        this.getActionMap().put("edit.redo", this.undoManager.getRedoAction());
    }

    @Override
    public void read(URI f, URIChooser chooser) throws IOException {
        String characterSet = chooser == null || !(chooser instanceof JFileURIChooser) || !(((JFileURIChooser)chooser).getAccessory() instanceof CharacterSetAccessory) ? prefs.get("characterSet", "UTF-8") : ((CharacterSetAccessory)((JFileURIChooser)chooser).getAccessory()).getCharacterSet();
        this.read(f, characterSet);
    }

    public void read(URI f, String characterSet) throws IOException {
        final Document doc = this.readDocument(new File(f), characterSet);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TeddyView.this.editor.getDocument().removeUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.editor.setDocument(doc);
                    doc.addUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.undoManager.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public void write(URI f, URIChooser chooser) throws IOException {
        String lineSeparator;
        String characterSet;
        if (chooser == null || !(chooser instanceof JFileURIChooser) || !(((JFileURIChooser)chooser).getAccessory() instanceof CharacterSetAccessory)) {
            characterSet = prefs.get("characterSet", "UTF-8");
            lineSeparator = prefs.get("lineSeparator", "\n");
        } else {
            characterSet = ((CharacterSetAccessory)((JFileURIChooser)chooser).getAccessory()).getCharacterSet();
            lineSeparator = ((CharacterSetAccessory)((JFileURIChooser)chooser).getAccessory()).getLineSeparator();
        }
        this.write(f, characterSet, lineSeparator);
    }

    public void write(URI f, String characterSet, String lineSeparator) throws IOException {
        this.writeDocument(this.editor.getDocument(), new File(f), characterSet, lineSeparator);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TeddyView.this.undoManager.setHasSignificantEdits(false);
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    private Document readDocument(File f, String characterSet) throws IOException {
        ProgressMonitorInputStream pin = new ProgressMonitorInputStream(this, "Reading " + f.getName(), new FileInputStream(f));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)pin, characterSet));
        try {
            String line;
            StyledDocument doc = this.createDocument();
            MutableAttributeSet attrs = ((StyledEditorKit)this.editor.getEditorKit()).getInputAttributes();
            boolean isFirst = true;
            while ((line = in.readLine()) != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    doc.insertString(doc.getLength(), "\n", attrs);
                }
                doc.insertString(doc.getLength(), line, attrs);
            }
            StyledDocument styledDocument = doc;
            return styledDocument;
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
        catch (OutOfMemoryError e) {
            System.err.println("out of memory!");
            throw new IOException("Out of memory.");
        }
        finally {
            in.close();
        }
    }

    @Override
    public void clear() {
        final StyledDocument newDocument = this.createDocument();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TeddyView.this.editor.getDocument().removeUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.editor.setDocument(newDocument);
                    newDocument.addUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.undoManager.discardAllEdits();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected StyledDocument createDocument() {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        doc.setParagraphAttributes(0, 1, ((StyledEditorKit)this.editor.getEditorKit()).getInputAttributes(), true);
        return doc;
    }

    private void writeDocument(Document doc, File f, String characterSet, String lineSeparator) throws IOException {
        LFWriter out = new LFWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), characterSet));
        out.setLineSeparator(lineSeparator);
        try {
            for (int i = 0; i < doc.getLength(); i += 256) {
                out.write(doc.getText(i, Math.min(256, doc.getLength() - i)));
            }
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            out.close();
            this.undoManager.discardAllEdits();
        }
    }

    private void initComponents() {
        this.statusBar = new JPanel();
        this.caretInfoLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.statusBar.setLayout(new BorderLayout());
        this.caretInfoLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.caretInfoLabel.setText("1:1");
        this.caretInfoLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 3));
        this.statusBar.add((Component)this.caretInfoLabel, "Center");
        this.add((Component)this.statusBar, "South");
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.scrollPane, "Center");
    }

    public Document getDocument() {
        return this.editor.getDocument();
    }

    public void select(int start, int end) {
        this.editor.select(start, end);
        try {
            this.editor.scrollRectToVisible(this.editor.modelToView(start));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public int getSelectionStart() {
        return this.editor.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.editor.getSelectionEnd();
    }

    public int getLineCount() {
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public void fireEdit(UndoableEdit edit) {
        this.undoManager.addEdit(edit);
    }

    private void caretUpdate(CaretEvent evt) {
        try {
            int pos = this.editor.getCaretPosition();
            int line = this.getLineOfOffset(pos);
            int lineStartOffset = this.getLineStartOffset(line);
            this.caretInfoLabel.setText(line + 1 + ":" + (pos - lineStartOffset + 1));
        }
        catch (BadLocationException e) {
            this.caretInfoLabel.setText(e.toString());
        }
    }

    public void setLineNumbersVisible(boolean newValue) {
        NumberedViewFactory viewFactory = (NumberedViewFactory)this.editor.getEditorKit().getViewFactory();
        boolean oldValue = viewFactory.isLineNumbersVisible();
        if (oldValue != newValue) {
            viewFactory.setLineNumbersVisible(newValue);
            prefs.putBoolean("lineNumbersVisible", newValue);
            this.firePropertyChange("lineNumbersVisible", oldValue, newValue);
            this.editor.revalidate();
            this.editor.repaint();
        }
    }

    public boolean isLineNumbersVisible() {
        NumberedViewFactory viewFactory = (NumberedViewFactory)this.editor.getEditorKit().getViewFactory();
        return viewFactory.isLineNumbersVisible();
    }

    private static class EditorPanel
    extends JPanel
    implements Scrollable {
        private JTextComponent editor;
        private boolean isLineWrap;

        private EditorPanel() {
        }

        public void setEditor(JTextComponent newValue) {
            this.editor = newValue;
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(this.editor);
            this.setBackground(UIManager.getColor("TextField.background"));
            this.setOpaque(true);
        }

        public void setLineWrap(boolean newValue) {
            this.isLineWrap = newValue;
            this.editor.revalidate();
            this.editor.repaint();
        }

        public boolean getLineWrap() {
            return this.isLineWrap;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.editor.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.editor.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.editor.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.isLineWrap;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.editor.getScrollableTracksViewportHeight();
        }
    }
}

