/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.gui;

import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.gui.ColorChooser;
import ij.gui.GUI;
import ij.plugin.LUT_Editor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import sc.fiji.i5d.Image5D;
import sc.fiji.i5d.cal.ChannelDisplayProperties;
import sc.fiji.i5d.gui.Image5DWindow;
import sc.fiji.i5d.gui.ScrollbarWithLabel;

public class ChannelControl
extends Panel
implements ItemListener,
AdjustmentListener,
ActionListener {
    private static final long serialVersionUID = -3537465383241321652L;
    Image5DWindow win;
    Image5D i5d;
    ImageJ ij;
    Choice displayChoice;
    int displayMode;
    boolean displayGrayInTiles;
    Panel selectorPanel;
    ScrollbarWithLabel scrollbarWL;
    ChannelSelectorOverlay channelSelectorOverlay;
    Panel tiledSelectorPanel;
    Checkbox allGrayInTilesBox;
    Button colorButton;
    boolean colorChooserDisplayed;
    ChannelColorChooser cColorChooser;
    int nChannels;
    int currentChannel;
    public static final int ONE_CHANNEL_GRAY = 0;
    public static final int ONE_CHANNEL_COLOR = 1;
    public static final int OVERLAY = 2;
    public static final int TILED = 3;
    public static final String[] displayModes = new String[]{"gray", "color", "overlay", "tiled"};
    public static final int DEFAULT_DISPLAY_MODE = 1;
    public static final String DISPLAY_MODE_PREF = "image5d.displayMode";
    public static final String BUTTON_ACTIVATE_COLOR_CHOOSER = "Color";
    public static final String BUTTON_DEACTIVATE_COLOR_CHOOSER = "Color";

    public ChannelControl(Image5DWindow win) {
        super(new BorderLayout(5, 5));
        this.win = win;
        this.i5d = (Image5D)win.getImagePlus();
        this.ij = IJ.getInstance();
        this.currentChannel = this.i5d.getCurrentChannel();
        this.nChannels = this.i5d.getNChannels();
        this.addKeyListener(win);
        this.addKeyListener((KeyListener)this.ij);
        this.addKeyListener(win);
        this.selectorPanel = new Panel(new BorderLayout(0, 0));
        this.add((Component)this.selectorPanel, "Center");
        Panel subPanel = new Panel(new GridLayout(2, 1, 1, 1));
        this.colorButton = new Button("Color");
        this.colorButton.setEnabled(true);
        this.colorChooserDisplayed = false;
        subPanel.add(this.colorButton);
        this.colorButton.addActionListener(this);
        this.colorButton.addKeyListener(win);
        this.colorButton.addKeyListener((KeyListener)this.ij);
        this.colorButton.addKeyListener(win);
        this.displayChoice = new Choice();
        for (String mode : displayModes) {
            this.displayChoice.add(mode);
        }
        this.displayChoice.select(this.displayMode);
        subPanel.add(this.displayChoice);
        this.displayChoice.addItemListener(this);
        this.displayChoice.addKeyListener(win);
        this.displayChoice.addKeyListener((KeyListener)this.ij);
        this.displayChoice.addKeyListener(win);
        this.selectorPanel.add((Component)subPanel, "North");
        this.addChannelSelectorOverlay();
        this.displayGrayInTiles = false;
        this.addTiledSelectorPanel();
        this.addScrollbar();
        if (this.nChannels <= 1 && this.scrollbarWL != null) {
            this.selectorPanel.remove(this.scrollbarWL);
        }
        this.cColorChooser = new ChannelColorChooser(this);
    }

    void addScrollbar() {
        this.nChannels = this.i5d.getNChannels();
        if (this.scrollbarWL == null) {
            this.scrollbarWL = new ScrollbarWithLabel(1, 1, 1, 1, this.nChannels + 1, this.i5d.getDimensionLabel(2));
            this.scrollbarWL.addAdjustmentListener(this);
            this.scrollbarWL.setFocusable(false);
        } else {
            this.scrollbarWL.setMaximum(this.nChannels + 1);
        }
        int blockIncrement = this.nChannels / 10;
        if (blockIncrement < 1) {
            blockIncrement = 1;
        }
        this.scrollbarWL.setUnitIncrement(1);
        this.scrollbarWL.setBlockIncrement(blockIncrement);
        if (this.channelSelectorOverlay != null) {
            this.selectorPanel.remove(this.channelSelectorOverlay);
        }
        if (this.tiledSelectorPanel != null) {
            this.selectorPanel.remove(this.tiledSelectorPanel);
        }
        this.selectorPanel.add((Component)this.scrollbarWL, "Center");
        this.win.pack();
        this.selectorPanel.repaint();
    }

    void addChannelSelectorOverlay() {
        if (this.channelSelectorOverlay == null) {
            this.channelSelectorOverlay = new ChannelSelectorOverlay(this);
        }
        if (this.scrollbarWL != null) {
            this.selectorPanel.remove(this.tiledSelectorPanel);
        }
        if (this.tiledSelectorPanel != null) {
            this.selectorPanel.remove(this.scrollbarWL);
        }
        this.selectorPanel.add((Component)this.channelSelectorOverlay, "Center");
        this.win.pack();
        this.selectorPanel.repaint();
    }

    void addTiledSelectorPanel() {
        if (this.channelSelectorOverlay == null) {
            this.channelSelectorOverlay = new ChannelSelectorOverlay(this);
        }
        if (this.tiledSelectorPanel == null) {
            this.tiledSelectorPanel = new Panel(new BorderLayout());
        }
        if (this.allGrayInTilesBox == null) {
            this.allGrayInTilesBox = new Checkbox("all gray", this.displayGrayInTiles);
            this.allGrayInTilesBox.addItemListener(this);
            this.allGrayInTilesBox.addKeyListener(this.win);
            this.allGrayInTilesBox.addKeyListener((KeyListener)this.ij);
            this.allGrayInTilesBox.addKeyListener(this.win);
        }
        if (this.channelSelectorOverlay != null) {
            this.selectorPanel.remove(this.channelSelectorOverlay);
        }
        if (this.scrollbarWL != null) {
            this.selectorPanel.remove(this.scrollbarWL);
        }
        this.tiledSelectorPanel.add((Component)this.allGrayInTilesBox, "North");
        this.tiledSelectorPanel.add((Component)this.channelSelectorOverlay, "Center");
        this.selectorPanel.add((Component)this.tiledSelectorPanel, "Center");
        this.win.pack();
        this.selectorPanel.repaint();
    }

    public int getNChannels() {
        return this.nChannels;
    }

    public void setNChannels(int nChannels) {
        int max;
        if (nChannels < 1) {
            return;
        }
        if (this.scrollbarWL != null && (max = this.scrollbarWL.getMaximum()) != nChannels + 1) {
            this.scrollbarWL.setMaximum(nChannels + 1);
        }
    }

    public int getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public Dimension getMinimumSize() {
        int width = this.selectorPanel.getMinimumSize().width;
        if (this.colorChooserDisplayed) {
            width += this.cColorChooser.getMinimumSize().width;
        }
        int height = this.selectorPanel.getMinimumSize().height;
        if (this.colorChooserDisplayed) {
            height = Math.max(height, this.cColorChooser.getMinimumSize().height);
        }
        if (height > 500) {
            height = 350;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.selectorPanel.getPreferredSize().width;
        if (this.colorChooserDisplayed) {
            width += this.cColorChooser.getPreferredSize().width;
        }
        int height = this.selectorPanel.getPreferredSize().height;
        if (this.colorChooserDisplayed) {
            height = Math.max(height, this.cColorChooser.getPreferredSize().height);
        }
        return new Dimension(width, height);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.displayChoice) {
            if (this.displayChoice.getSelectedIndex() == this.displayMode) {
                return;
            }
            this.i5d.setDisplayMode(this.displayChoice.getSelectedIndex());
            this.updateChannelSelector();
        } else if (e.getSource() == this.allGrayInTilesBox) {
            if (this.allGrayInTilesBox.getState() == this.displayGrayInTiles) {
                return;
            }
            this.displayGrayInTiles = this.allGrayInTilesBox.getState();
            this.i5d.setDisplayGrayInTiles(this.displayGrayInTiles);
        }
    }

    public synchronized void updateSelectorDisplay() {
        this.nChannels = this.i5d.getNChannels();
        if (this.nChannels <= 1) {
            this.selectorPanel.remove(this.scrollbarWL);
            this.selectorPanel.remove(this.channelSelectorOverlay);
            this.selectorPanel.remove(this.tiledSelectorPanel);
        } else if (this.displayMode == 2) {
            this.addChannelSelectorOverlay();
        } else if (this.displayMode == 3) {
            this.addTiledSelectorPanel();
        } else {
            this.addScrollbar();
        }
    }

    public synchronized void setDisplayMode(int mode) {
        if (mode == this.displayMode) {
            return;
        }
        if (mode == 0) {
            if (this.colorChooserDisplayed) {
                this.remove(this.cColorChooser);
                this.colorButton.setLabel("Color");
                this.colorChooserDisplayed = false;
            }
            this.colorButton.setEnabled(false);
            if (this.nChannels > 1) {
                this.addScrollbar();
            }
        } else if (mode == 1) {
            this.colorButton.setEnabled(true);
            if (this.nChannels > 1) {
                this.addScrollbar();
            }
        } else if (mode == 2) {
            this.colorButton.setEnabled(true);
            if (this.nChannels > 1) {
                this.addChannelSelectorOverlay();
            }
        } else if (mode == 3) {
            this.colorButton.setEnabled(true);
            if (this.nChannels > 1) {
                this.addTiledSelectorPanel();
            }
        } else {
            throw new IllegalArgumentException("Unknown display mode: " + mode);
        }
        this.displayMode = mode;
        this.displayChoice.select(mode);
        Prefs.set((String)DISPLAY_MODE_PREF, (String)displayModes[this.displayMode]);
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public synchronized void setDisplayGrayInTiles(boolean displayGrayInTiles) {
        if (this.displayGrayInTiles == displayGrayInTiles && this.allGrayInTilesBox != null && this.allGrayInTilesBox.getState() == displayGrayInTiles) {
            return;
        }
        this.displayGrayInTiles = displayGrayInTiles;
        if (this.allGrayInTilesBox != null) {
            this.allGrayInTilesBox.setState(displayGrayInTiles);
        }
    }

    public boolean isDisplayGrayInTiles() {
        return this.displayGrayInTiles;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.scrollbarWL != null && e.getSource() == this.scrollbarWL) {
            this.currentChannel = this.scrollbarWL.getValue();
            this.channelChanged(this.currentChannel);
        }
    }

    public void channelChanged(int newChannel) {
        this.currentChannel = newChannel;
        this.win.channelChanged();
        this.cColorChooser.channelChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton) {
            if (this.colorChooserDisplayed) {
                this.remove(this.cColorChooser);
                this.colorButton.setLabel("Color");
                this.colorChooserDisplayed = false;
                this.win.pack();
            } else {
                this.add((Component)this.cColorChooser, "East");
                this.colorButton.setLabel("Color");
                this.colorChooserDisplayed = true;
                this.win.pack();
            }
        }
    }

    public void updateChannelSelector() {
        this.currentChannel = this.i5d.getCurrentChannel();
        this.nChannels = this.i5d.getNChannels();
        int max = this.scrollbarWL.getMaximum();
        if (max != this.nChannels + 1) {
            this.scrollbarWL.setMaximum(this.nChannels + 1);
        }
        this.scrollbarWL.setValue(this.i5d.getCurrentChannel());
        this.channelSelectorOverlay.updateFromI5D();
        this.cColorChooser.channelChanged();
    }

    protected class ChannelColorCanvas
    extends Canvas
    implements MouseListener {
        private static final long serialVersionUID = 3918313955836224104L;
        ChannelColorChooser cColorChooser;
        Image lutImage;
        Image colorPickerImage;
        Image commonsImage;
        int lutWidth = 15;
        int lutHeight = 129;
        int cpNHues = 24;
        int cpNSats = 8;
        int cpRectWidth = 10;
        int cpRectHeight = 10;
        int cpWidth;
        int cpHeight;
        int commonsWidth = 0;
        int commonsHeight = 0;
        int hSpacer = 5;
        int vSpacer = 0;
        int canvasWidth;
        int canvasHeight;

        public ChannelColorCanvas(ChannelColorChooser cColorChooser) {
            this.cColorChooser = cColorChooser;
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            this.cpWidth = this.cpRectWidth * this.cpNSats;
            this.cpHeight = this.cpRectHeight * this.cpNHues;
            this.canvasWidth = this.lutWidth + 2 + this.hSpacer + this.cpWidth + 2;
            this.canvasHeight = this.cpHeight + 2 + this.vSpacer + this.commonsHeight;
            this.setSize(this.canvasWidth, this.canvasHeight);
            this.lutImage = GUI.createBlankImage((int)(this.lutWidth + 2), (int)(this.lutHeight + 2));
            this.colorPickerImage = GUI.createBlankImage((int)(this.cpWidth + 2), (int)(this.cpHeight + 2));
            this.drawLUT();
            this.drawColorPicker();
            this.addMouseListener(this);
        }

        void drawLUT() {
            int i;
            Graphics g = this.lutImage.getGraphics();
            int[] rgb = new int[256];
            ColorModel currentLUT = ChannelControl.this.i5d.getChannelDisplayProperties(this.cColorChooser.cControl.currentChannel).getColorModel();
            if (!(currentLUT instanceof IndexColorModel)) {
                throw new IllegalArgumentException("Color Model has to be IndexColorModel.");
            }
            for (i = 0; i < 256; ++i) {
                rgb[i] = ((IndexColorModel)currentLUT).getRGB(i);
            }
            g.setColor(Color.black);
            g.drawRect(0, 0, this.lutWidth + 2, this.lutHeight + 2);
            g.setColor(new Color(rgb[255]));
            g.drawLine(1, 1, this.lutWidth, 1);
            for (i = 0; i < 128; ++i) {
                g.setColor(new Color(rgb[255 - i * 2]));
                g.drawLine(1, i + 2, this.lutWidth, i + 2);
            }
        }

        void drawColorPicker() {
            Graphics g = this.colorPickerImage.getGraphics();
            float hue = 0.0f;
            float sat = 0.0f;
            g.setColor(Color.black);
            g.drawRect(0, 0, this.cpWidth + 2, this.cpHeight + 2);
            for (int h = 0; h < this.cpNHues; ++h) {
                for (int s = 0; s < this.cpNSats; ++s) {
                    hue = (float)h / (float)this.cpNHues;
                    sat = (float)s / (float)(this.cpNSats - 1);
                    g.setColor(Color.getHSBColor(hue, sat, 1.0f));
                    g.fillRect(this.cpWidth - (s + 1) * this.cpRectWidth + 1, h * this.cpRectHeight + 1, this.cpRectWidth, this.cpRectHeight);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.colorPickerImage, this.lutWidth + 2 + this.hSpacer, 0, this.cpWidth + 2, this.cpHeight + 2, null);
            this.drawLUT();
            g.drawImage(this.lutImage, 0, 0, this.lutWidth + 2, this.lutHeight + 2, null);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.canvasWidth, this.canvasHeight);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.canvasWidth, this.canvasHeight);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            Rectangle colorPickerRect = new Rectangle(this.lutWidth + 2 + this.hSpacer + 1, 1, this.cpWidth, this.cpHeight);
            int x = e.getX();
            if (colorPickerRect.contains(x, y = e.getY())) {
                ColorChooser cc;
                int xCP = x - (this.lutWidth + 2 + this.hSpacer);
                int yCP = y;
                int[] pixels32 = new int[1];
                PixelGrabber pg = new PixelGrabber(this.colorPickerImage, xCP, yCP, 1, 1, pixels32, 0, this.cpWidth);
                pg.setColorModel(ColorModel.getRGBdefault());
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException ie) {
                    return;
                }
                Color c = new Color(pixels32[0]);
                this.cColorChooser.setColor(c);
                if (e.getClickCount() == 2 && (c = (cc = new ColorChooser("Channel Color", c, false)).getColor()) != null) {
                    this.cColorChooser.setColor(c);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    protected class ChannelColorChooser
    extends Panel
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -2987819237979841674L;
        ChannelControl cControl;
        Checkbox displayGrayBox;
        Button editColorButton;
        Button editLUTButton;
        ChannelColorCanvas cColorCanvas;

        public ChannelColorChooser(ChannelControl cControl) {
            super(new BorderLayout(5, 5));
            this.cControl = cControl;
            this.displayGrayBox = new Checkbox("Grayscale");
            this.displayGrayBox.setState(ChannelControl.this.i5d.getChannelDisplayProperties(cControl.currentChannel).isDisplayedGray());
            this.displayGrayBox.addItemListener(this);
            this.add((Component)this.displayGrayBox, "North");
            this.cColorCanvas = new ChannelColorCanvas(this);
            this.add((Component)this.cColorCanvas, "Center");
            Panel tempPanel = new Panel(new GridLayout(2, 1, 5, 2));
            this.editColorButton = new Button("Edit Color");
            this.editColorButton.addActionListener(this);
            tempPanel.add(this.editColorButton);
            this.editLUTButton = new Button("Edit LUT");
            this.editLUTButton.addActionListener(this);
            tempPanel.add(this.editLUTButton);
            this.add((Component)tempPanel, "South");
            this.addKeyListener(ChannelControl.this.win);
            this.displayGrayBox.addKeyListener(ChannelControl.this.win);
            this.cColorCanvas.addKeyListener(ChannelControl.this.win);
            this.editColorButton.addKeyListener(ChannelControl.this.win);
            this.editLUTButton.addKeyListener(ChannelControl.this.win);
            this.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.displayGrayBox.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.cColorCanvas.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.editColorButton.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.editLUTButton.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.addKeyListener(ChannelControl.this.win);
            this.displayGrayBox.addKeyListener(ChannelControl.this.win);
            this.cColorCanvas.addKeyListener(ChannelControl.this.win);
            this.editColorButton.addKeyListener(ChannelControl.this.win);
            this.editLUTButton.addKeyListener(ChannelControl.this.win);
        }

        public void setColor(Color c) {
            ChannelControl.this.i5d.storeChannelProperties(this.cControl.currentChannel);
            ChannelControl.this.i5d.getChannelDisplayProperties(this.cControl.currentChannel).setColorModel(ChannelDisplayProperties.createModelFromColor(c));
            ChannelControl.this.i5d.restoreChannelProperties(this.cControl.currentChannel);
            ChannelControl.this.i5d.updateAndDraw();
            this.cControl.updateChannelSelector();
            this.cColorCanvas.repaint();
        }

        public void channelChanged() {
            this.cColorCanvas.repaint();
            this.displayGrayBox.setState(ChannelControl.this.i5d.getChannelDisplayProperties(this.cControl.currentChannel).isDisplayedGray());
            this.cColorCanvas.setEnabled(!this.displayGrayBox.getState());
            this.editColorButton.setEnabled(!this.displayGrayBox.getState());
            this.editLUTButton.setEnabled(!this.displayGrayBox.getState());
        }

        @Override
        public Dimension getMinimumSize() {
            int width = this.cColorCanvas.getMinimumSize().width;
            int height = this.displayGrayBox.getMinimumSize().height + 5 + this.cColorCanvas.getMinimumSize().height + 5 + this.editColorButton.getMinimumSize().height + 5 + this.editLUTButton.getMinimumSize().height;
            return new Dimension(width, height);
        }

        @Override
        public Dimension getPreferredSize() {
            int width = this.cColorCanvas.getPreferredSize().width;
            int height = this.displayGrayBox.getPreferredSize().height + 5 + this.cColorCanvas.getPreferredSize().height + 5 + this.editColorButton.getPreferredSize().height + 5 + this.editLUTButton.getPreferredSize().height;
            return new Dimension(width, height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorModel cm = ChannelControl.this.i5d.getChannelDisplayProperties(this.cControl.currentChannel).getColorModel();
            ChannelControl.this.i5d.storeChannelProperties(this.cControl.currentChannel);
            if (e.getSource() == this.editLUTButton) {
                new LUT_Editor().run("");
                cm = ChannelControl.this.i5d.getProcessor(this.cControl.currentChannel).getColorModel();
            } else if (e.getSource() == this.editColorButton) {
                Color c = new Color(ChannelControl.this.i5d.getProcessor(this.cControl.currentChannel).getColorModel().getRGB(255));
                ColorChooser cc = new ColorChooser("Channel Color", c, false);
                if ((c = cc.getColor()) != null) {
                    cm = ChannelDisplayProperties.createModelFromColor(c);
                }
            }
            ChannelControl.this.i5d.getChannelDisplayProperties(this.cControl.currentChannel).setColorModel(cm);
            ChannelControl.this.i5d.restoreChannelProperties(this.cControl.currentChannel);
            ChannelControl.this.i5d.updateAndDraw();
            this.cControl.updateChannelSelector();
            this.cColorCanvas.repaint();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() == this.displayGrayBox) {
                ChannelControl.this.i5d.storeChannelProperties(this.cControl.currentChannel);
                ChannelControl.this.i5d.getChannelDisplayProperties(this.cControl.currentChannel).setDisplayedGray(this.displayGrayBox.getState());
                ChannelControl.this.i5d.restoreChannelProperties(this.cControl.currentChannel);
                ChannelControl.this.i5d.updateImageAndDraw();
                this.cColorCanvas.setEnabled(!this.displayGrayBox.getState());
                this.editColorButton.setEnabled(!this.displayGrayBox.getState());
                this.editLUTButton.setEnabled(!this.displayGrayBox.getState());
            }
        }
    }

    protected class ChannelSelectorOverlay
    extends Panel
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -8138803830180530129L;
        ChannelControl cControl;
        Panel allNonePanel;
        Button allButton;
        Button noneButton;
        ScrollPane channelPane;
        Panel channelPanel;
        Checkbox[] channelDisplayed;
        Checkbox[] channelActive;
        CheckboxGroup channelActiveGroup;
        int nChannels;

        public ChannelSelectorOverlay(ChannelControl cControl) {
            super(new BorderLayout());
            this.cControl = cControl;
            this.nChannels = cControl.nChannels;
            this.allNonePanel = new Panel(new GridLayout(1, 2));
            this.allButton = new Button("All");
            this.allButton.addActionListener(this);
            this.allNonePanel.add(this.allButton);
            this.noneButton = new Button("None");
            this.noneButton.addActionListener(this);
            this.allNonePanel.add(this.noneButton);
            this.add((Component)this.allNonePanel, "North");
            this.addKeyListener(ChannelControl.this.win);
            this.allButton.addKeyListener(ChannelControl.this.win);
            this.noneButton.addKeyListener(ChannelControl.this.win);
            this.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.allButton.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.noneButton.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.addKeyListener(ChannelControl.this.win);
            this.allButton.addKeyListener(ChannelControl.this.win);
            this.noneButton.addKeyListener(ChannelControl.this.win);
            this.buildChannelSelector();
        }

        protected void buildChannelSelector() {
            this.channelPane = new ScrollPane(0);
            this.channelPanel = new Panel();
            this.channelPane.add(this.channelPanel);
            this.add((Component)this.channelPane, "Center");
            this.channelPane.addMouseWheelListener((MouseWheelListener)((Object)ChannelControl.this.win));
            this.channelPane.addKeyListener(ChannelControl.this.win);
            this.channelPanel.addKeyListener(ChannelControl.this.win);
            this.channelPane.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.channelPanel.addKeyListener((KeyListener)ChannelControl.this.ij);
            this.channelPane.addKeyListener(ChannelControl.this.win);
            this.channelPanel.addKeyListener(ChannelControl.this.win);
            this.nChannels = 0;
            this.updateFromI5D();
        }

        public void updateFromI5D() {
            int i;
            if (this.nChannels != ChannelControl.this.i5d.getNChannels()) {
                this.nChannels = ChannelControl.this.i5d.getNChannels();
                this.channelPane.getVAdjustable().setUnitIncrement(20);
                this.channelPanel.removeAll();
                this.channelPanel.setLayout(new GridLayout(this.nChannels, 1));
                this.channelActiveGroup = new CheckboxGroup();
                this.channelDisplayed = new Checkbox[this.nChannels];
                this.channelActive = new Checkbox[this.nChannels];
                for (i = 0; i < this.nChannels; ++i) {
                    Panel p = new Panel(new BorderLayout());
                    this.channelActive[i] = new Checkbox();
                    this.channelActive[i].setCheckboxGroup(this.channelActiveGroup);
                    this.channelActive[i].addItemListener(this);
                    p.add((Component)this.channelActive[i], "West");
                    this.channelDisplayed[i] = new Checkbox();
                    this.channelDisplayed[i].addItemListener(this);
                    p.add((Component)this.channelDisplayed[i], "Center");
                    this.channelPanel.add(p);
                    this.channelActive[i].addKeyListener(ChannelControl.this.win);
                    this.channelDisplayed[i].addKeyListener(ChannelControl.this.win);
                    this.channelActive[i].addKeyListener((KeyListener)ChannelControl.this.ij);
                    this.channelDisplayed[i].addKeyListener((KeyListener)ChannelControl.this.ij);
                    this.channelActive[i].addKeyListener(ChannelControl.this.win);
                    this.channelDisplayed[i].addKeyListener(ChannelControl.this.win);
                }
                ChannelControl.this.win.pack();
            }
            for (i = 0; i < this.nChannels; ++i) {
                this.channelActive[i].setBackground(new Color(ChannelControl.this.i5d.getChannelDisplayProperties(i + 1).getColorModel().getRGB(255)));
                this.channelActive[i].setForeground(Color.black);
                this.channelActive[i].repaint();
                this.channelDisplayed[i].setLabel(ChannelControl.this.i5d.getChannelCalibration(i + 1).getLabel());
                this.channelDisplayed[i].setState(ChannelControl.this.i5d.getChannelDisplayProperties(i + 1).isDisplayedInOverlay());
                this.channelDisplayed[i].setBackground(new Color(ChannelControl.this.i5d.getChannelDisplayProperties(i + 1).getColorModel().getRGB(255)));
                this.channelDisplayed[i].setForeground(Color.black);
                this.channelDisplayed[i].repaint();
            }
            this.channelActive[ChannelControl.this.i5d.getCurrentChannel() - 1].setState(true);
        }

        @Override
        public Dimension getMinimumSize() {
            int widthButtons = this.allNonePanel.getMinimumSize().width;
            int widthChecks = this.channelPane.getMinimumSize().width;
            int width = Math.max(widthButtons, widthChecks);
            int height = this.allNonePanel.getMinimumSize().height;
            return new Dimension(width, height += this.nChannels * this.channelDisplayed[0].getMinimumSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            int widthButtons = this.allNonePanel.getPreferredSize().width;
            int widthChecks = this.channelPane.getPreferredSize().width;
            int width = Math.max(widthButtons, widthChecks);
            int height = this.allNonePanel.getPreferredSize().height;
            return new Dimension(width, height += this.nChannels * this.channelDisplayed[0].getPreferredSize().height);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.allButton) {
                for (int i = 0; i < this.nChannels; ++i) {
                    this.channelDisplayed[i].setState(true);
                    ChannelControl.this.i5d.setDisplayedInOverlay(i + 1, true);
                }
                this.updateFromI5D();
                ChannelControl.this.i5d.updateImageAndDraw();
            } else if (e.getSource() == this.noneButton) {
                for (int i = 0; i < this.nChannels; ++i) {
                    this.channelDisplayed[i].setState(false);
                    ChannelControl.this.i5d.setDisplayedInOverlay(i + 1, false);
                }
                this.updateFromI5D();
                ChannelControl.this.i5d.updateImageAndDraw();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            for (int i = 0; i < this.nChannels; ++i) {
                if (e.getItemSelectable() == this.channelDisplayed[i]) {
                    if (e.getStateChange() == 1) {
                        ChannelControl.this.i5d.setDisplayedInOverlay(i + 1, true);
                    } else if (e.getStateChange() == 2) {
                        ChannelControl.this.i5d.setDisplayedInOverlay(i + 1, false);
                    }
                    this.updateFromI5D();
                    ChannelControl.this.i5d.updateImageAndDraw();
                    return;
                }
                if (e.getItemSelectable() != this.channelActive[i] || e.getStateChange() != 1) continue;
                ChannelControl.this.currentChannel = i + 1;
                this.cControl.channelChanged(ChannelControl.this.currentChannel);
                return;
            }
        }
    }
}

