/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.plugin.PlugIn;
import java.awt.Frame;
import sc.fiji.i5d.Image5D;

public class New_Image5D
implements PlugIn {
    private static final int OLD_FILL_WHITE = 0;
    static final String NAME = "new.name";
    static final String TYPE = "new.type";
    static final String FILL = "new.fill";
    static final String WIDTH = "new.width";
    static final String HEIGHT = "new.height";
    static final String CHANNELS = "new.channels";
    static final String SLICES = "new.slices";
    static final String FRAMES = "new.frames";
    private static String name = Prefs.getString((String)"new.name", (String)"Untitled");
    private static int width = Prefs.getInt((String)"new.width", (int)400);
    private static int height = Prefs.getInt((String)"new.height", (int)400);
    private static int channels = Prefs.getInt((String)"new.channels", (int)1);
    private static int slices = Prefs.getInt((String)"new.slices", (int)1);
    private static int frames = Prefs.getInt((String)"new.frames", (int)1);
    private static int type = Prefs.getInt((String)"new.type", (int)0);
    private static int fillWith = Prefs.getInt((String)"new.fill", (int)0);
    private static String[] types = new String[]{"8-bit", "16-bit", "32-bit"};
    private static String[] fill = new String[]{"White", "Black", "Ramp"};

    public void run(String arg) {
        this.openImage();
    }

    public static Image5D createImage5D(String title, int width, int height, int nChannels, int nSlices, int nFrames, int bitDepth, int options, boolean fill) {
        int imageType = 0;
        switch (bitDepth) {
            case 8: {
                imageType = 0;
                break;
            }
            case 16: {
                imageType = 1;
                break;
            }
            case 32: {
                imageType = 2;
                break;
            }
            default: {
                return null;
            }
        }
        options |= 8;
        Image5D i5d = new Image5D(title, imageType, width, height, nChannels, nSlices, nFrames, fill);
        if (fill) {
            for (int c = 1; c <= nChannels; ++c) {
                for (int s = 1; s <= nSlices; ++s) {
                    for (int f = 1; f <= nFrames; ++f) {
                        ImagePlus imp = NewImage.createImage((String)title, (int)width, (int)height, (int)1, (int)bitDepth, (int)options);
                        i5d.setPixels(imp.getProcessor().getPixels(), c, s, f);
                    }
                }
            }
        } else {
            ImagePlus imp = NewImage.createImage((String)title, (int)width, (int)height, (int)1, (int)bitDepth, (int)options);
            for (int c = 1; c <= nChannels; ++c) {
                for (int s = 1; s <= nSlices; ++s) {
                    for (int f = 1; f <= nFrames; ++f) {
                        i5d.setPixels(imp.getProcessor().getPixels(), c, s, f);
                    }
                }
            }
        }
        i5d.updateImageAndDraw();
        return i5d;
    }

    boolean showDialog() {
        if (type < 0 || type > 2) {
            type = 0;
        }
        if (fillWith < 0 || fillWith > 2) {
            fillWith = 0;
        }
        GenericDialog gd = new GenericDialog("New...", (Frame)IJ.getInstance());
        gd.addStringField("Name:", name, 12);
        gd.addChoice("Type:", types, types[type]);
        gd.addChoice("Fill With:", fill, fill[fillWith]);
        gd.addNumericField("Width:", (double)width, 0, 5, "pixels");
        gd.addNumericField("Height:", (double)height, 0, 5, "pixels");
        gd.addNumericField("Channels:", (double)channels, 0, 5, "");
        gd.addNumericField("Slices:", (double)slices, 0, 5, "");
        gd.addNumericField("Frames:", (double)frames, 0, 5, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        String s = gd.getNextChoice();
        type = s.startsWith("8") ? 0 : (s.startsWith("16") ? 1 : 2);
        fillWith = gd.getNextChoiceIndex();
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        channels = (int)gd.getNextNumber();
        slices = (int)gd.getNextNumber();
        frames = (int)gd.getNextNumber();
        return true;
    }

    public static void openImage5D(String title, int width, int height, int nChannels, int nSlices, int nFrames, int type, int options, boolean fill) {
        int bitDepth = 8;
        if (type == 1) {
            bitDepth = 16;
        } else if (type == 2) {
            bitDepth = 32;
        }
        long startTime = System.currentTimeMillis();
        Image5D i5d = New_Image5D.createImage5D(title, width, height, nChannels, nSlices, nFrames, bitDepth, options, true);
        i5d.setDefaultColors();
        i5d.setDefaultChannelNames();
        i5d.show(IJ.d2s((double)((double)(System.currentTimeMillis() - startTime) / 1000.0), (int)2) + " seconds");
    }

    void openImage() {
        if (!this.showDialog()) {
            return;
        }
        try {
            New_Image5D.openImage5D(name, width, height, channels, slices, frames, type, fillWith, true);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory((String)"New_Image5D");
        }
    }
}

