/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.convert;

import java.util.function.Supplier;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.blocks.AbstractDimensionlessBlockProcessor;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.convert.PrimitiveTypeProperties;
import net.imglib2.converter.Converter;
import net.imglib2.img.AbstractImg;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Cast;

class ConverterBlockProcessor<S extends NativeType<S>, T extends NativeType<T>, I, O>
extends AbstractDimensionlessBlockProcessor<I, O> {
    private final S sourceType;
    private final T targetType;
    private final Supplier<Converter<? super S, T>> converterSupplier;
    private final Converter<? super S, T> converter;
    private final Wrapper<S> wrapSource;
    private final Wrapper<T> wrapTarget;

    public ConverterBlockProcessor(S sourceType, T targetType, Supplier<Converter<? super S, T>> converterSupplier) {
        super(sourceType.getNativeTypeFactory().getPrimitiveType());
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.converterSupplier = converterSupplier;
        this.converter = converterSupplier.get();
        this.wrapSource = Wrapper.of(sourceType);
        this.wrapTarget = Wrapper.of(targetType);
    }

    private ConverterBlockProcessor(ConverterBlockProcessor<S, T, I, O> convert) {
        super(convert);
        this.sourceType = convert.sourceType;
        this.targetType = convert.targetType;
        this.converterSupplier = convert.converterSupplier;
        this.converter = this.converterSupplier.get();
        this.wrapSource = Wrapper.of(this.sourceType);
        this.wrapTarget = Wrapper.of(this.targetType);
    }

    @Override
    public BlockProcessor<I, O> independentCopy() {
        return new ConverterBlockProcessor<S, T, I, O>(this);
    }

    @Override
    public void compute(I src, O dest) {
        S in = this.wrapSource.wrap(src);
        T out = this.wrapTarget.wrap(dest);
        int len = this.sourceLength();
        for (int i = 0; i < len; ++i) {
            in.index().set(i);
            out.index().set(i);
            this.converter.convert(in, out);
        }
    }

    private static class WrapperImpl<T extends NativeType<T>, A>
    extends AbstractImg<T>
    implements NativeImg<T, A>,
    Wrapper<T> {
        private final PrimitiveTypeProperties<?, A> props;
        private Object array;
        private final T wrapper;

        WrapperImpl(T type) {
            super(new long[0]);
            NativeTypeFactory nativeTypeFactory = (NativeTypeFactory)Cast.unchecked(type.getNativeTypeFactory());
            this.props = (PrimitiveTypeProperties)Cast.unchecked(PrimitiveTypeProperties.get(nativeTypeFactory.getPrimitiveType()));
            this.wrapper = nativeTypeFactory.createLinkedType(this);
        }

        @Override
        public T wrap(Object array) {
            this.array = array;
            this.wrapper.updateContainer(null);
            return this.wrapper;
        }

        @Override
        public A update(Object updater) {
            return this.props.wrap(this.array);
        }

        @Override
        public void setLinkedType(T type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T createLinkedType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Cursor<T> cursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Cursor<T> localizingCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object iterationOrder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RandomAccess<T> randomAccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImgFactory<T> factory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Img<T> copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getType() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface Wrapper<T extends NativeType<T>> {
        public T wrap(Object var1);

        public static <T extends NativeType<T>> Wrapper<T> of(T type) {
            return new WrapperImpl(type);
        }
    }
}

