/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution;

import java.util.concurrent.ExecutorService;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.LineConvolverFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.parallel.Parallelization;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.parallel.TaskExecutors;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.util.Localizables;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class LineConvolution<T>
implements Convolution<T> {
    private final LineConvolverFactory<? super T> factory;
    private final int direction;
    private ExecutorService executor;

    public LineConvolution(LineConvolverFactory<? super T> factory, int direction) {
        this.factory = factory;
        this.direction = direction;
    }

    @Override
    @Deprecated
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Interval requiredSourceInterval(Interval targetInterval) {
        long[] min = Intervals.minAsLongArray(targetInterval);
        long[] max = Intervals.maxAsLongArray(targetInterval);
        int n = this.direction;
        min[n] = min[n] - this.factory.getBorderBefore();
        int n2 = this.direction;
        max[n2] = max[n2] + this.factory.getBorderAfter();
        return new FinalInterval(min, max);
    }

    @Override
    public T preferredSourceType(T targetType) {
        return Cast.unchecked(this.factory.preferredSourceType(targetType));
    }

    @Override
    public void process(RandomAccessible<? extends T> source, RandomAccessibleInterval<? extends T> target) {
        IntervalView<? extends T> sourceInterval = Views.interval(source, this.requiredSourceInterval(target));
        long[] sourceMin = Intervals.minAsLongArray(sourceInterval);
        long[] targetMin = Intervals.minAsLongArray(target);
        long[] dim = Intervals.dimensionsAsLongArray(target);
        dim[this.direction] = 1L;
        RandomAccessibleInterval<Localizable> positions = Localizables.randomAccessibleInterval(new FinalInterval(dim));
        TaskExecutor taskExecutor = this.executor == null ? Parallelization.getTaskExecutor() : TaskExecutors.forExecutorService(this.executor);
        LoopBuilder.setImages(positions).multiThreaded(taskExecutor).forEachChunk(chunk -> {
            RandomAccess in = sourceInterval.randomAccess();
            RandomAccess out = target.randomAccess();
            Runnable convolver = this.factory.getConvolver(in, out, this.direction, target.dimension(this.direction));
            chunk.forEachPixel(position -> {
                in.setPosition(sourceMin);
                out.setPosition(targetMin);
                in.move((Localizable)position);
                out.move((Localizable)position);
                convolver.run();
            });
            return null;
        });
    }
}

