/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.metrics.imagequality;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.metrics.imagequality.MSE;
import net.imglib2.algorithm.stats.ComputeMinMax;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class NRMSE {
    public static <T extends RealType<T>> double computeMetrics(RandomAccessibleInterval<T> reference, RandomAccessibleInterval<T> processed, Normalization norm) {
        if (!Intervals.equalDimensions(reference, processed)) {
            throw new IllegalArgumentException("Image dimensions must match.");
        }
        double mse = MSE.computeMetrics(reference, processed);
        double nFactor = norm == Normalization.EUCLIDEAN ? NRMSE.getEuclideanNorm(reference) : (norm == Normalization.MINMAX ? NRMSE.getMinMaxNorm(reference) : NRMSE.getMean(reference));
        return nFactor > 0.0 ? Math.sqrt(mse) / nFactor : Double.NaN;
    }

    protected static <T extends RealType<T>> double getEuclideanNorm(RandomAccessibleInterval<T> reference) {
        long nPixels = Intervals.numElements(reference);
        if (nPixels > 0L) {
            double ms = 0.0;
            RealCursor cu = Views.iterable(reference).cursor();
            while (cu.hasNext()) {
                double dRef = ((RealType)cu.next()).getRealDouble();
                ms += dRef * dRef / (double)nPixels;
            }
            return Math.sqrt(ms);
        }
        return Double.NaN;
    }

    protected static <T extends RealType<T>> double getMinMaxNorm(RandomAccessibleInterval<T> reference) {
        RealType min = (RealType)((RealType)reference.randomAccess().get()).copy();
        RealType max = (RealType)min.copy();
        ComputeMinMax.computeMinMax(reference, min, max);
        return max.getRealDouble() - min.getRealDouble();
    }

    protected static <T extends RealType<T>> double getMean(RandomAccessibleInterval<T> reference) {
        long nPixels = Intervals.numElements(reference);
        if (nPixels > 0L) {
            double mean = 0.0;
            RealCursor cu = Views.iterable(reference).cursor();
            while (cu.hasNext()) {
                double dRef = ((RealType)cu.next()).getRealDouble();
                mean += dRef / (double)nPixels;
            }
            return mean;
        }
        return Double.NaN;
    }

    public static enum Normalization {
        EUCLIDEAN,
        MINMAX,
        MEAN;

    }
}

