/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region;

import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.region.CircleCursor;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.operators.Add;

public class Circles {
    public static <T extends RealType<T>> void inc(RandomAccessible<T> rai, Localizable center, long radius) {
        Circles.inc(rai, center, radius, 0, 1);
    }

    public static <T extends RealType<T>> void inc(RandomAccessible<T> rai, Localizable center, long radius, int dimX, int dimY) {
        CircleCursor<T> cursor = new CircleCursor<T>(rai, center, radius, dimX, dimY);
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).inc();
        }
    }

    public static <T extends Type<T>> void set(RandomAccessible<T> rai, Localizable center, long radius, T value) {
        Circles.set(rai, center, radius, 0, 1, value);
    }

    public static <T extends Type<T>> void set(RandomAccessible<T> rai, Localizable center, long radius, int dimX, int dimY, T value) {
        CircleCursor<T> cursor = new CircleCursor<T>(rai, center, radius, dimX, dimY);
        while (cursor.hasNext()) {
            cursor.fwd();
            ((Type)cursor.get()).set(value);
        }
    }

    public static <T extends Add<T>> void add(RandomAccessible<T> rai, Localizable center, long radius, T value) {
        Circles.add(rai, center, radius, 0, 1, value);
    }

    public static <T extends Add<T>> void add(RandomAccessible<T> rai, Localizable center, long radius, int dimX, int dimY, T value) {
        CircleCursor<T> cursor = new CircleCursor<T>(rai, center, radius, dimX, dimY);
        while (cursor.hasNext()) {
            cursor.fwd();
            ((Add)cursor.get()).add(value);
        }
    }

    private Circles() {
    }
}

