/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.geometry.Sphere;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class BoundingSphere
extends BranchGroup {
    private final Point3f center;
    private float radius;
    private final Color3f color;
    private final float transparency;
    private final TransformGroup scaleTG;
    private final Transform3D scale = new Transform3D();
    private final TransformGroup translateTG;
    private final Transform3D translate = new Transform3D();
    private final TransparencyAttributes ta;
    private final PolygonAttributes pa;
    private final ColoringAttributes ca;
    private final Appearance appearance;

    public BoundingSphere(Point3f center, float radius) {
        this(center, radius, new Color3f(1.0f, 0.0f, 0.0f));
    }

    public BoundingSphere(Point3f center, float radius, Color3f color) {
        this(center, radius, color, 0.0f);
    }

    public BoundingSphere(Point3f center, float radius, Color3f color, float transparency) {
        this.setCapability(17);
        this.center = new Point3f(center);
        this.radius = radius;
        this.color = color;
        this.transparency = transparency;
        this.appearance = new Appearance();
        this.pa = new PolygonAttributes();
        this.pa.setPolygonMode(1);
        this.pa.setCullFace(0);
        this.appearance.setPolygonAttributes(this.pa);
        this.ta = new TransparencyAttributes();
        this.ta.setTransparency(transparency);
        this.ta.setTransparencyMode(0);
        this.appearance.setTransparencyAttributes(this.ta);
        this.ca = new ColoringAttributes();
        this.ca.setColor(color);
        this.appearance.setColoringAttributes(this.ca);
        Sphere sphere = new Sphere(1.0f, this.appearance);
        sphere.setName("BS");
        Vector3f translateV = new Vector3f((Tuple3f)center);
        this.translate.set(translateV);
        this.translateTG = new TransformGroup(this.translate);
        this.translateTG.setCapability(18);
        this.scale.set((double)radius);
        this.scaleTG = new TransformGroup(this.scale);
        this.scaleTG.setCapability(18);
        this.scaleTG.addChild((Node)sphere);
        this.translateTG.addChild((Node)this.scaleTG);
        this.addChild((Node)this.translateTG);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.scale.set((double)radius);
        this.scaleTG.setTransform(this.scale);
    }

    public void setCenter(Point3f center) {
        this.center.set((Tuple3f)center);
        Vector3f translateV = new Vector3f((Tuple3f)center);
        this.translate.set(translateV);
        this.translateTG.setTransform(this.translate);
    }

    public void getTransform(Transform3D transform) {
        transform.set(new Vector3f((Tuple3f)this.center));
        transform.mul(this.scale);
    }

    public void getTransformInverse(Transform3D transform) {
        this.getTransform(transform);
        transform.invert();
    }

    public String toString() {
        return "[BoundingSphere center: " + this.center + " radius: " + this.radius + "] " + ((Object)((Object)this)).hashCode();
    }
}

