/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomMultiMesh;
import customnode.CustomTriangleMesh;
import ij.IJ;
import ij.gui.GenericDialog;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.Image3DUniverse;
import isosurface.MeshEditor;
import isosurface.MeshGroup;
import java.awt.Choice;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

public class SmoothControl {
    private final Originals originals = new Originals();

    private static final void apply(CustomTriangleMesh m, List<Point3f> triangles) {
        List current = m.getMesh();
        for (int i = 0; i < current.size(); ++i) {
            ((Point3f)current.get(i)).set((Tuple3f)triangles.get(i));
        }
        m.update();
    }

    public static final Set<CustomTriangleMesh> findMeshes(Content content) {
        CustomTriangleMesh m;
        HashSet<CustomTriangleMesh> meshes = new HashSet<CustomTriangleMesh>();
        if (null == content) {
            return meshes;
        }
        ContentInstant ci = content.getCurrent();
        if (null == ci) {
            return meshes;
        }
        ContentNode node = ci.getContent();
        if (null == node) {
            return meshes;
        }
        if (node instanceof CustomMultiMesh) {
            CustomMultiMesh multi = (CustomMultiMesh)node;
            for (int i = 0; i < multi.size(); ++i) {
                CustomMesh m2 = multi.getMesh(i);
                if (!(m2 instanceof CustomTriangleMesh)) continue;
                meshes.add((CustomTriangleMesh)m2);
            }
        } else if (node instanceof CustomMeshNode) {
            CustomMesh m3 = ((CustomMeshNode)node).getMesh();
            if (m3 instanceof CustomTriangleMesh) {
                meshes.add((CustomTriangleMesh)m3);
            }
        } else if (node instanceof MeshGroup && (m = ((MeshGroup)node).getMesh()) instanceof CustomTriangleMesh) {
            meshes.add(m);
        }
        return meshes;
    }

    private static final void smooth(CustomTriangleMesh tm, int iterations, Originals originals) {
        List triangles = originals.getCopyOfOriginals(tm);
        MeshEditor.smooth2(triangles, iterations);
        SmoothControl.apply(tm, triangles);
    }

    private static final void smooth(Content c, int iterations, Originals originals) {
        if (null == c) {
            return;
        }
        ContentNode cn = c.getContent();
        Set<CustomTriangleMesh> meshes = SmoothControl.findMeshes(c);
        if (meshes.isEmpty()) {
            IJ.log((String)("Cannot smooth content of class " + ((Object)((Object)cn)).getClass()));
            return;
        }
        originals.add(c);
        for (CustomTriangleMesh tm : meshes) {
            SmoothControl.smooth(tm, iterations, originals);
        }
    }

    private static Task launchTask(GenericDialog gd, Scrollbar s, Choice c, Object pivot, Task[] state, final Runnable r) {
        return new Task(pivot, state){
            {
                super(pivot, state);
                this.setPriority(5);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                Object object = this.pivot;
                synchronized (object) {
                    if (null == this.next) {
                        this.state[0] = null;
                    } else {
                        this.state[0] = this.next;
                        this.next.start();
                    }
                }
            }
        };
    }

    public SmoothControl(final Image3DUniverse univ) {
        this.originals.copy(univ, false);
        final Task[] lastTask = new Task[1];
        final Object pivot = new Object();
        final GenericDialog gd = new GenericDialog("Smooth meshes"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent we) {
                GenericDialog gd = (GenericDialog)we.getSource();
                if (gd.wasCanceled()) {
                    Object object = pivot;
                    synchronized (object) {
                        if (null != lastTask[0]) {
                            lastTask[0].interrupt();
                            lastTask[0] = null;
                        }
                    }
                    new Thread(){
                        {
                            this.setPriority(5);
                        }

                        @Override
                        public void run() {
                            SmoothControl.this.originals.restore(null);
                        }
                    }.start();
                    return;
                }
                if (gd.wasOKed()) {
                    return;
                }
            }
        };
        gd.addSlider("Iterations", 0.0, 100.0, 0.0);
        final Scrollbar slider = (Scrollbar)gd.getSliders().get(0);
        String[] c = new String[]{"Selected mesh", "All meshes"};
        gd.addChoice("Process", c, c[0]);
        final Choice choice = (Choice)gd.getChoices().get(0);
        final int[] all = new int[1];
        final int[] lastValue = new int[1];
        Listener listener = new Listener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                this.run(slider.getValue());
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                if (ae.getValueIsAdjusting()) {
                    return;
                }
                if (!slider.isEnabled()) {
                    IJ.log((String)"slider not enabled!");
                    return;
                }
                int v = slider.getValue();
                if (v == lastValue[0]) {
                    return;
                }
                lastValue[0] = v;
                this.run(v);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void run(int iterations) {
                Object object = pivot;
                synchronized (object) {
                    if (!gd.isVisible()) {
                        return;
                    }
                    if (null != lastTask[0]) {
                        lastTask[0].launchWhenDone(this.task(iterations));
                    } else {
                        lastTask[0] = this.task(iterations);
                        lastTask[0].start();
                    }
                }
            }

            private final Task task(final int iterations) {
                IJ.showStatus((String)("Smoothing with " + iterations + " iterations"));
                return SmoothControl.launchTask(gd, slider, choice, pivot, lastTask, new Runnable(){

                    @Override
                    public void run() {
                        int choiceValue = choice.getSelectedIndex();
                        if (0 == iterations) {
                            SmoothControl.this.originals.restore(null);
                            return;
                        }
                        if (1 == all[0] && 0 == choiceValue) {
                            SmoothControl.this.originals.restore(univ.getSelected());
                            return;
                        }
                        if (1 == choiceValue) {
                            for (Content c : univ.getContents()) {
                                if (0 == all[0] && 1 == choiceValue && c == univ.getSelected()) continue;
                                SmoothControl.smooth(c, iterations, SmoothControl.this.originals);
                            }
                        } else {
                            SmoothControl.smooth(univ.getSelected(), iterations, SmoothControl.this.originals);
                        }
                        all[0] = choiceValue;
                    }
                });
            }
        };
        slider.addAdjustmentListener(listener);
        choice.addItemListener(listener);
        gd.setModal(false);
        gd.showDialog();
    }

    private static interface Listener
    extends AdjustmentListener,
    ItemListener {
    }

    private static class Task
    extends Thread {
        final Task[] state;
        final Object pivot;
        Task next = null;

        private Task(Object pivot, Task[] state) {
            this.pivot = pivot;
            this.state = state;
        }

        private void launchWhenDone(Task next) {
            this.next = next;
            this.interrupt();
        }
    }

    private static final class Originals {
        private final Map<CustomTriangleMesh, List<Point3f>> data = new HashMap<CustomTriangleMesh, List<Point3f>>();

        private Originals() {
        }

        private void restore(Content except) {
            Set<CustomTriangleMesh> avoid = SmoothControl.findMeshes(except);
            for (Map.Entry<CustomTriangleMesh, List<Point3f>> e : this.data.entrySet()) {
                if (avoid.contains((Object)e.getKey())) continue;
                SmoothControl.apply(e.getKey(), e.getValue());
            }
            IJ.showStatus((String)"Restored meshes");
        }

        private void copy(Image3DUniverse univ, boolean all) {
            if (all) {
                for (Content c : univ.getContents()) {
                    this.add(c);
                }
            } else {
                this.add(univ.getSelected());
            }
        }

        private final List<Point3f> getCopyOfOriginals(CustomTriangleMesh tm) {
            return this.deepCopy(this.data.get((Object)tm));
        }

        private void add(Content content) {
            for (CustomTriangleMesh tm : SmoothControl.findMeshes(content)) {
                if (this.data.containsKey((Object)tm)) continue;
                this.data.put(tm, this.deepCopy(tm.getMesh()));
            }
        }

        private final List<Point3f> deepCopy(List<Point3f> t) {
            ArrayList<Point3f> list = new ArrayList<Point3f>(t.size());
            for (Point3f p : t) {
                list.add(new Point3f(p));
            }
            return list;
        }
    }
}

