/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.inverse;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.inverse.BacktrackingLineSearch;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;

public class InvertibleTransformByGradientDescent
implements InvertibleRealTransform {
    final boolean isInverse;
    final DifferentiableRealTransform forwardTransform;
    final BacktrackingLineSearch inverseTransform;

    public InvertibleTransformByGradientDescent(DifferentiableRealTransform forwardTransform) {
        this(forwardTransform, false);
    }

    public InvertibleTransformByGradientDescent(DifferentiableRealTransform forwardTransform, boolean isInverse) {
        this(forwardTransform, new BacktrackingLineSearch(forwardTransform), isInverse);
    }

    public InvertibleTransformByGradientDescent(DifferentiableRealTransform forwardTransform, BacktrackingLineSearch inverseTransform, boolean isInverse) {
        this.forwardTransform = forwardTransform;
        this.inverseTransform = inverseTransform;
        this.isInverse = isInverse;
    }

    @Override
    public void apply(double[] p, double[] q) {
        if (this.isInverse) {
            this.inverseTransform.iterativeInverse(p, q);
        } else {
            this.forwardTransform.apply(p, q);
        }
    }

    @Override
    public void apply(RealLocalizable p, RealPositionable q) {
        if (this.isInverse) {
            double[] pd = new double[p.numDimensions()];
            double[] qd = new double[p.numDimensions()];
            p.localize(pd);
            this.inverseTransform.iterativeInverse(pd, qd);
            q.setPosition(qd);
        } else {
            this.forwardTransform.apply(p, q);
        }
    }

    @Override
    public void applyInverse(double[] p, double[] q) {
        if (this.isInverse) {
            this.forwardTransform.apply(p, q);
        } else {
            this.inverseTransform.iterativeInverse(p, q);
        }
    }

    @Override
    public void applyInverse(RealPositionable p, RealLocalizable q) {
        if (this.isInverse) {
            this.forwardTransform.apply(q, p);
        } else {
            double[] pd = new double[p.numDimensions()];
            double[] qd = new double[p.numDimensions()];
            q.localize(qd);
            this.inverseTransform.iterativeInverse(qd, pd);
            p.setPosition(pd);
        }
    }

    @Override
    public InvertibleTransformByGradientDescent copy() {
        return new InvertibleTransformByGradientDescent(this.forwardTransform, this.isInverse);
    }

    @Override
    public InvertibleTransformByGradientDescent inverse() {
        return new InvertibleTransformByGradientDescent(this.forwardTransform, !this.isInverse);
    }

    @Override
    public int numSourceDimensions() {
        return this.forwardTransform.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.forwardTransform.numTargetDimensions();
    }
}

