/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.roi.MorphDilate;
import mpicbg.imglib.algorithm.roi.MorphErode;
import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class MorphOpen<T extends RealType<T>>
implements OutputAlgorithm<T>,
Benchmark {
    private final Image<T> image;
    private Image<T> outputImage;
    private MorphDilate<T> dilater;
    private final MorphErode<T> eroder;
    private final StructuringElement strel;
    private final OutOfBoundsStrategyFactory<T> outsideFactory;
    private long pTime;

    public MorphOpen(Image<T> imageIn, StructuringElement strelIn) {
        this(imageIn, strelIn, null);
    }

    public MorphOpen(Image<T> imageIn, StructuringElement strelIn, OutOfBoundsStrategyFactory<T> inOutsideFactory) {
        this.image = imageIn;
        this.strel = strelIn;
        this.eroder = new MorphErode<T>(this.image, this.strel, inOutsideFactory);
        this.dilater = null;
        this.outputImage = null;
        this.outsideFactory = inOutsideFactory;
        this.pTime = 0L;
    }

    @Override
    public Image<T> getResult() {
        return this.outputImage;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        String errorMsg = "";
        errorMsg = errorMsg + this.eroder.getErrorMessage();
        if (this.dilater != null) {
            errorMsg = errorMsg + this.dilater.getErrorMessage();
        }
        return errorMsg;
    }

    @Override
    public boolean process() {
        long sTime = System.currentTimeMillis();
        this.pTime = 0L;
        boolean rVal = false;
        if (this.eroder.process()) {
            this.dilater = new MorphDilate(this.eroder.getResult(), this.strel, this.outsideFactory);
            this.dilater.setName(this.image.getName() + " Opened");
            rVal = this.dilater.process();
        }
        this.outputImage = rVal ? this.dilater.getResult() : null;
        this.pTime = System.currentTimeMillis() - sTime;
        return rVal;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

