/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyPeriodicFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.RealTypeImpl;

public class SubpixelLocalization<T extends RealType<T>>
implements Algorithm,
Benchmark,
MultiThreaded {
    Image<T> laPlacian;
    List<DifferenceOfGaussianPeak<T>> peaks;
    int maxNumMoves = 4;
    boolean allowMaximaTolerance = false;
    boolean canMoveOutside = false;
    float maximaTolerance = 0.01f;
    final ImageFactory<DoubleType> doubleArrayFactory;
    boolean[] allowedToMoveInDim;
    long processingTime;
    int numThreads = 1;
    String errorMessage = "";

    public SubpixelLocalization(Image<T> laPlacian, List<DifferenceOfGaussianPeak<T>> peaks) {
        this.setNumThreads();
        this.laPlacian = laPlacian;
        this.peaks = peaks;
        this.allowedToMoveInDim = new boolean[laPlacian.getNumDimensions()];
        for (int d = 0; d < this.allowedToMoveInDim.length; ++d) {
            this.allowedToMoveInDim[d] = true;
        }
        this.doubleArrayFactory = new ImageFactory<DoubleType>(new DoubleType(), new ArrayContainerFactory());
    }

    public void setAllowMaximaTolerance(boolean allowMaximaTolerance) {
        this.allowMaximaTolerance = allowMaximaTolerance;
    }

    public void setCanMoveOutside(boolean canMoveOutside) {
        this.canMoveOutside = canMoveOutside;
    }

    public void setMaximaTolerance(float maximaTolerance) {
        this.maximaTolerance = maximaTolerance;
    }

    public void setLaPlaceImage(Image<T> laPlacian) {
        this.laPlacian = laPlacian;
    }

    public void setDoGPeaks(List<DifferenceOfGaussianPeak<T>> peaks) {
        this.peaks = peaks;
    }

    public void setMaxNumMoves(int maxNumMoves) {
        this.maxNumMoves = maxNumMoves;
    }

    public void setAllowedToMoveInDim(boolean[] allowedToMoveInDim) {
        this.allowedToMoveInDim = (boolean[])allowedToMoveInDim.clone();
    }

    public boolean getAllowMaximaTolerance() {
        return this.allowMaximaTolerance;
    }

    public boolean getCanMoveOutside() {
        return this.canMoveOutside;
    }

    public float getMaximaTolerance() {
        return this.maximaTolerance;
    }

    public Image<T> getLaPlaceImage() {
        return this.laPlacian;
    }

    public List<DifferenceOfGaussianPeak<T>> getDoGPeaks() {
        return this.peaks;
    }

    public int getMaxNumMoves() {
        return this.maxNumMoves;
    }

    public boolean[] getAllowedToMoveInDim() {
        return (boolean[])this.allowedToMoveInDim.clone();
    }

    protected boolean handleFailure(DifferenceOfGaussianPeak<T> peak, String error) {
        peak.setPeakType(DifferenceOfGaussian.SpecialPoint.INVALID);
        peak.setErrorMessage(error);
        return false;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    for (int i = 0; i < SubpixelLocalization.this.peaks.size(); ++i) {
                        DifferenceOfGaussianPeak peak;
                        if (i % numThreads != myNumber) continue;
                        List list = SubpixelLocalization.this.peaks;
                        synchronized (list) {
                            peak = SubpixelLocalization.this.peaks.get(i);
                        }
                        SubpixelLocalization.this.analyzePeak(peak);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    public boolean analyzePeak(DifferenceOfGaussianPeak<T> peak) {
        int d;
        Matrix X;
        Matrix B;
        int numDimensions = this.laPlacian.getNumDimensions();
        double[] subpixelLocation = new double[numDimensions];
        int[] currentPosition = peak.getPosition();
        LocalizableByDimCursor<T> cursor = this.canMoveOutside ? this.laPlacian.createLocalizableByDimCursor(new OutOfBoundsStrategyPeriodicFactory()) : this.laPlacian.createLocalizableByDimCursor();
        Image<DoubleType> hessianMatrix = this.doubleArrayFactory.createImage(new int[]{cursor.getNumDimensions(), cursor.getNumDimensions()});
        Image<DoubleType> derivativeVector = this.doubleArrayFactory.createImage(new int[]{cursor.getNumDimensions()});
        RealType value = (RealType)((RealType)peak.value).createVariable();
        boolean foundStableMaxima = true;
        boolean pointsValid = false;
        int numMoves = 0;
        do {
            int d2;
            ++numMoves;
            cursor.setPosition(currentPosition);
            value.set(cursor.getType());
            hessianMatrix = this.getHessianMatrix(cursor, hessianMatrix);
            Matrix A = this.invertMatrix(hessianMatrix);
            if (A == null) {
                cursor.close();
                hessianMatrix.close();
                derivativeVector.close();
                return this.handleFailure(peak, "Cannot invert hessian matrix");
            }
            B = SubpixelLocalization.getMatrix(derivativeVector = this.getDerivativeVector(cursor, derivativeVector));
            if (B == null) {
                cursor.close();
                hessianMatrix.close();
                derivativeVector.close();
                return this.handleFailure(peak, "Cannot compute derivative vector");
            }
            X = A.uminus().times(B);
            for (d2 = 0; d2 < numDimensions; ++d2) {
                subpixelLocation[d2] = X.get(d2, 0);
            }
            foundStableMaxima = true;
            for (d2 = 0; d2 < numDimensions; ++d2) {
                double threshold;
                double d3 = threshold = this.allowMaximaTolerance ? 0.5 + (double)((float)numMoves * this.maximaTolerance) : 0.5;
                if (!(Math.abs(subpixelLocation[d2]) > threshold)) continue;
                if (this.allowedToMoveInDim[d2]) {
                    int n = d2;
                    currentPosition[n] = (int)((double)currentPosition[n] + Math.signum(subpixelLocation[d2]));
                    foundStableMaxima = false;
                    continue;
                }
                subpixelLocation[d2] = Math.signum(subpixelLocation[d2]) * 0.5;
            }
            pointsValid = true;
            if (this.canMoveOutside || foundStableMaxima) continue;
            for (d2 = 0; d2 < numDimensions; ++d2) {
                if (currentPosition[d2] > 0 && currentPosition[d2] < this.laPlacian.getDimension(d2) - 1) continue;
                pointsValid = false;
            }
        } while (numMoves <= this.maxNumMoves && !foundStableMaxima && pointsValid);
        cursor.close();
        hessianMatrix.close();
        derivativeVector.close();
        if (!foundStableMaxima) {
            return this.handleFailure(peak, "No stable extremum found.");
        }
        if (!pointsValid) {
            return this.handleFailure(peak, "Moved outside of the image.");
        }
        double quadrFuncValue = 0.0;
        for (d = 0; d < numDimensions; ++d) {
            quadrFuncValue += X.get(d, 0) * B.get(d, 0);
        }
        quadrFuncValue /= 2.0;
        for (d = 0; d < numDimensions; ++d) {
            peak.setSubPixelLocationOffset((float)subpixelLocation[d], d);
        }
        peak.setPixelLocation(currentPosition);
        RealType quadraticFit = (RealType)((RealType)peak.getImgValue()).createVariable();
        quadraticFit.setReal(quadrFuncValue);
        peak.setFitValue(quadraticFit);
        peak.setImgValue(value);
        return true;
    }

    protected Matrix invertMatrix(Image<DoubleType> matrixImage) {
        Matrix matrix = SubpixelLocalization.getMatrix(matrixImage);
        if (matrix == null) {
            return null;
        }
        return SubpixelLocalization.computePseudoInverseMatrix(matrix, 0.001);
    }

    protected Image<DoubleType> getDerivativeVector(LocalizableByDimCursor<T> cursor, Image<DoubleType> derivativeVector) {
        SubpixelLocalization.computeDerivativeVector(cursor, derivativeVector);
        return derivativeVector;
    }

    protected Image<DoubleType> getHessianMatrix(LocalizableByDimCursor<T> cursor, Image<DoubleType> hessianMatrix) {
        SubpixelLocalization.computeHessianMatrix(cursor, hessianMatrix);
        return hessianMatrix;
    }

    public static <S extends RealType<S>> Matrix getMatrix(Image<S> maxtrixImage) {
        Matrix matrix;
        int numDimensions = maxtrixImage.getNumDimensions();
        if (numDimensions > 2) {
            return null;
        }
        if (numDimensions == 1) {
            matrix = new Matrix(maxtrixImage.getDimension(0), 1);
            LocalizableCursor<S> cursor = maxtrixImage.createLocalizableCursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                matrix.set(cursor.getPosition(0), 0, ((RealType)cursor.getType()).getRealDouble());
            }
            cursor.close();
        } else {
            matrix = new Matrix(maxtrixImage.getDimension(0), maxtrixImage.getDimension(1));
            LocalizableCursor<S> cursor = maxtrixImage.createLocalizableCursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                matrix.set(cursor.getPosition(0), cursor.getPosition(1), ((RealType)cursor.getType()).getRealDouble());
            }
            cursor.close();
        }
        return matrix;
    }

    public static final Matrix computePseudoInverseMatrix(Matrix M, double threshold) {
        SingularValueDecomposition svd = new SingularValueDecomposition(M);
        Matrix U = svd.getU();
        Matrix S = svd.getS();
        Matrix V = svd.getV();
        for (int j = 0; j < S.getRowDimension(); ++j) {
            double temp = S.get(j, j);
            temp = temp < threshold ? 1.0 / threshold : 1.0 / temp;
            S.set(j, j, temp);
        }
        U = U.transpose();
        return V.times(S).times(U);
    }

    public static final <T extends RealType<T>> Image<DoubleType> computeDerivativeVector(LocalizableByDimCursor<T> cursor) {
        ImageFactory<DoubleType> factory = new ImageFactory<DoubleType>(new DoubleType(), new ArrayContainerFactory());
        Image<DoubleType> derivativeVector = factory.createImage(new int[]{cursor.getNumDimensions()});
        SubpixelLocalization.computeDerivativeVector(cursor, derivativeVector);
        return derivativeVector;
    }

    public static final <T extends RealType<T>> void computeDerivativeVector(LocalizableByDimCursor<T> cursor, Image<DoubleType> derivativeVector) {
        LocalizableCursor<DoubleType> derivativeCursor = derivativeVector.createLocalizableCursor();
        while (derivativeCursor.hasNext()) {
            derivativeCursor.fwd();
            int dim = derivativeCursor.getPosition(0);
            cursor.fwd(dim);
            double a2 = ((RealType)cursor.getType()).getRealDouble();
            cursor.bck(dim);
            cursor.bck(dim);
            double a0 = ((RealType)cursor.getType()).getRealDouble();
            cursor.fwd(dim);
            ((DoubleType)derivativeCursor.getType()).setReal((a2 - a0) / 2.0);
        }
        derivativeCursor.close();
    }

    public static final <T extends RealType<T>> Image<DoubleType> computeHessianMatrix(LocalizableByDimCursor<T> cursor) {
        ImageFactory<DoubleType> factory = new ImageFactory<DoubleType>(new DoubleType(), new ArrayContainerFactory());
        Image<DoubleType> hessianMatrix = factory.createImage(new int[]{cursor.getNumDimensions(), cursor.getNumDimensions()});
        SubpixelLocalization.computeHessianMatrix(cursor, hessianMatrix);
        return hessianMatrix;
    }

    public static final <T extends RealType<T>> void computeHessianMatrix(LocalizableByDimCursor<T> cursor, Image<DoubleType> hessianMatrix) {
        double temp = 2.0 * ((RealType)cursor.getType()).getRealDouble();
        LocalizableCursor<DoubleType> hessianCursor = hessianMatrix.createLocalizableCursor();
        LocalizableByDimCursor<DoubleType> hessianCursorLowerHalf = hessianMatrix.createLocalizableByDimCursor();
        while (hessianCursor.hasNext()) {
            hessianCursor.fwd();
            int dimA = hessianCursor.getPosition(0);
            int dimB = hessianCursor.getPosition(1);
            if (dimA == dimB) {
                cursor.fwd(dimA);
                double a2 = ((RealType)cursor.getType()).getRealDouble();
                cursor.bck(dimA);
                cursor.bck(dimA);
                double a0 = ((RealType)cursor.getType()).getRealDouble();
                cursor.fwd(dimA);
                ((DoubleType)hessianCursor.getType()).set(a2 - temp + a0);
                continue;
            }
            if (dimB <= dimA) continue;
            cursor.fwd(dimB);
            cursor.fwd(dimA);
            double a2b2 = ((RealType)cursor.getType()).getRealDouble();
            cursor.bck(dimA);
            cursor.bck(dimA);
            double a0b2 = ((RealType)cursor.getType()).getRealDouble();
            cursor.bck(dimB);
            cursor.bck(dimB);
            double a0b0 = ((RealType)cursor.getType()).getRealDouble();
            cursor.fwd(dimA);
            cursor.fwd(dimA);
            double a2b0 = ((RealType)cursor.getType()).getRealDouble();
            cursor.bck(dimA);
            cursor.fwd(dimB);
            ((DoubleType)hessianCursor.getType()).set(((a2b2 - a0b2) / 2.0 - (a2b0 - a0b0) / 2.0) / 2.0);
            hessianCursorLowerHalf.setPosition(dimB, 0);
            hessianCursorLowerHalf.setPosition(dimA, 1);
            ((DoubleType)hessianCursorLowerHalf.getType()).set((RealTypeImpl)hessianCursor.getType());
        }
        hessianCursor.close();
        hessianCursorLowerHalf.close();
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.laPlacian == null) {
            this.errorMessage = "SubpixelLocalization: [Image<T> img] is null.";
            return false;
        }
        if (this.peaks == null) {
            this.errorMessage = "SubpixelLocalization: [List<DifferenceOfGaussianPeak<T>> peaks] is null.";
            return false;
        }
        if (this.peaks.size() == 0) {
            this.errorMessage = "SubpixelLocalization: [List<DifferenceOfGaussianPeak<T>> peaks] is empty.";
            return false;
        }
        return true;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }
}

