/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIOByteArray
implements ArrayDataAccess<NIOByteArray>,
ByteAccess {
    protected ByteBuffer data;

    public NIOByteArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 4).order(ByteOrder.nativeOrder());
    }

    public NIOByteArray(byte[] data) {
        ByteBuffer bufferIn = ByteBuffer.wrap(data);
        ByteBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder());
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public byte getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, byte value) {
        this.data.put(index, value);
    }

    public byte[] getCurrentStorageArray() {
        byte[] outData = new byte[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIOByteArray createArray(int numEntities) {
        return new NIOByteArray(numEntities);
    }
}

