/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class Array3DLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends ArrayLocalizableByDimOutOfBoundsCursor<T>
implements LocalizableByDimCursor3D<T> {
    protected int x = -1;
    protected int y = 0;
    protected int z = 0;
    final int widthMinus1;
    final int heightMinus1;
    final int depthMinus1;
    final int width;
    final int height;
    final int depth;
    final int stepY;
    final int stepZ;
    final Array3D<T, ?> container;

    public Array3DLocalizableByDimOutOfBoundsCursor(Array3D<T, ?> container, Image<T> image, T type, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(container, image, type, outOfBoundsStrategyFactory);
        this.container = container;
        this.widthMinus1 = container.getWidth() - 1;
        this.heightMinus1 = container.getHeight() - 1;
        this.depthMinus1 = container.getDepth() - 1;
        this.width = container.getWidth();
        this.height = container.getHeight();
        this.depth = container.getDepth();
        this.stepY = container.getWidth();
        this.stepZ = container.getWidth() * container.getHeight();
        this.reset();
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            this.type.incIndex();
            if (this.x < this.widthMinus1) {
                ++this.x;
            } else if (this.y < this.heightMinus1) {
                this.x = 0;
                ++this.y;
            } else if (this.z < this.depthMinus1) {
                this.x = 0;
                this.y = 0;
                ++this.z;
            } else {
                this.isOutOfBounds = true;
                ++this.x;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isOutOfBounds = false;
        this.isClosed = false;
        this.x = -1;
        this.z = 0;
        this.y = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] position) {
        position[0] = this.x;
        position[1] = this.y;
        position[2] = this.z;
    }

    @Override
    public Array3D<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public int getPosition(int dim) {
        if (dim == 0) {
            return this.x;
        }
        if (dim == 1) {
            return this.y;
        }
        if (dim == 2) {
            return this.z;
        }
        System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.getPosition( int dim ): There is no dimension " + dim);
        return -1;
    }

    @Override
    public void fwd(int dim) {
        if (dim == 0) {
            this.fwdX();
        } else if (dim == 1) {
            this.fwdY();
        } else if (dim == 2) {
            this.fwdZ();
        } else {
            System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.fwd( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public void fwdX() {
        if (this.isOutOfBounds) {
            if (this.x == -1) {
                this.setPositionX(0);
            } else {
                ++this.x;
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(0);
            }
        } else if (this.x < this.widthMinus1) {
            this.type.incIndex();
            ++this.x;
        } else {
            ++this.x;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwdY() {
        if (this.isOutOfBounds) {
            if (this.y == -1) {
                this.setPositionY(0);
            } else {
                ++this.y;
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(1);
            }
        } else if (this.y < this.heightMinus1) {
            this.type.incIndex(this.stepY);
            ++this.y;
        } else {
            ++this.y;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwdZ() {
        if (this.isOutOfBounds) {
            if (this.z == -1) {
                this.setPositionZ(0);
            } else {
                ++this.z;
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(2);
            }
        } else if (this.z < this.depthMinus1) {
            this.type.incIndex(this.stepZ);
            ++this.z;
        } else {
            ++this.z;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int steps, int dim) {
        if (dim == 0) {
            this.moveX(steps);
        } else if (dim == 1) {
            this.moveY(steps);
        } else if (dim == 2) {
            this.moveZ(steps);
        } else {
            System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.move( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public void moveRel(int x, int y, int z) {
        this.moveX(x);
        this.moveY(y);
        this.moveZ(z);
    }

    @Override
    public void moveTo(int x, int y, int z) {
        this.moveX(x - this.x);
        this.moveY(y - this.y);
        this.moveZ(z - this.z);
    }

    @Override
    public void moveX(int steps) {
        this.x += steps;
        if (this.isOutOfBounds) {
            if (this.x > -1 && this.x < this.width) {
                if (this.y < 0 || this.y >= this.height || this.z < 0 || this.z >= this.depth) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(steps, 0);
                } else {
                    this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
                    this.type.updateContainer(this);
                    this.isOutOfBounds = false;
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(steps, 0);
            }
        } else if (this.x > -1 && this.x < this.width) {
            this.type.incIndex(steps);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void moveY(int steps) {
        this.y += steps;
        if (this.isOutOfBounds) {
            if (this.y > -1 && this.y < this.height) {
                if (this.x < 0 || this.x >= this.width || this.z < 0 || this.z >= this.depth) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(steps, 1);
                } else {
                    this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
                    this.type.updateContainer(this);
                    this.isOutOfBounds = false;
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(steps, 1);
            }
        } else if (this.y > -1 && this.y < this.height) {
            this.type.incIndex(steps * this.stepY);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void moveZ(int steps) {
        this.z += steps;
        if (this.isOutOfBounds) {
            if (this.z > -1 && this.z < this.depth) {
                if (this.y < 0 || this.y >= this.height || this.x < 0 || this.x >= this.width) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(steps, 2);
                } else {
                    this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
                    this.type.updateContainer(this);
                    this.isOutOfBounds = false;
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(steps, 2);
            }
        } else if (this.z > -1 && this.z < this.depth) {
            this.type.incIndex(steps * this.stepZ);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int dim) {
        if (dim == 0) {
            this.bckX();
        } else if (dim == 1) {
            this.bckY();
        } else if (dim == 2) {
            this.bckZ();
        } else {
            System.err.println("Array3DLocalizableByDimCursor.bck( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public void bckX() {
        if (this.isOutOfBounds) {
            if (this.x == this.width) {
                this.setPositionX(this.widthMinus1);
            } else {
                --this.x;
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(0);
            }
        } else {
            --this.x;
            if (this.x > -1) {
                this.type.decIndex();
            } else {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void bckY() {
        if (this.isOutOfBounds) {
            if (this.y == this.height) {
                this.setPositionY(this.heightMinus1);
            } else {
                --this.y;
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(1);
            }
        } else {
            --this.y;
            if (this.y > -1) {
                this.type.decIndex(this.stepY);
            } else {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void bckZ() {
        if (this.isOutOfBounds) {
            if (this.z == this.depth) {
                this.setPositionZ(this.depthMinus1);
            } else {
                --this.z;
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(2);
            }
        } else {
            --this.z;
            if (this.z > -1) {
                this.type.decIndex(this.stepZ);
            } else {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void setPosition(int[] position) {
        this.setPosition(position[0], position[1], position[2]);
    }

    @Override
    public void setPosition(int posX, int posY, int posZ) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        if (posX > -1 && posX < this.width && posY > -1 && posY < this.height && posZ > -1 && posZ < this.depth) {
            this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
            if (this.isOutOfBounds) {
                this.type.updateContainer(this);
            }
            this.isOutOfBounds = false;
        } else if (this.isOutOfBounds) {
            this.outOfBoundsStrategy.notifyOutOfBOunds();
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPositionX(int pos) {
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(pos, this.y, this.z);
        } else if (pos > -1 && pos < this.width) {
            this.type.incIndex(pos - this.x);
            this.x = pos;
        } else {
            this.x = pos;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPositionY(int pos) {
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.x, pos, this.z);
        } else if (pos > -1 && pos < this.height) {
            this.type.incIndex((pos - this.y) * this.stepY);
            this.y = pos;
        } else {
            this.y = pos;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPositionZ(int pos) {
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.x, this.y, pos);
        } else if (pos > -1 && pos < this.depth) {
            this.type.incIndex((pos - this.z) * this.stepZ);
            this.z = pos;
        } else {
            this.z = pos;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        if (dim == 0) {
            this.setPositionX(position);
        } else if (dim == 1) {
            this.setPositionY(position);
        } else if (dim == 2) {
            this.setPositionZ(position);
        } else {
            System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.setPosition( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public String getPositionAsString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

