/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.special.AbstractSpecialCursor;
import mpicbg.imglib.type.Type;

public abstract class CoordsCursor<T extends Type<T>>
extends AbstractSpecialCursor<T> {
    protected float[] calibration;
    protected int[] origin;
    protected int[] position;

    public final void moveCenterTo(Localizable localizable) {
        localizable.getPosition(this.origin);
        this.reset();
    }

    public final void moveCenterToPosition(int[] icenter) {
        this.origin = (int[])icenter.clone();
        this.reset();
    }

    public final void moveCenterToCoordinates(float[] coords) {
        for (int i = 0; i < this.origin.length; ++i) {
            this.origin[i] = Math.round(coords[i] / this.calibration[i]);
        }
        this.reset();
    }

    public final double getDistanceSquared() {
        double sum = 0.0;
        for (int i = 0; i < this.position.length; ++i) {
            sum += (double)((float)(this.position[i] * this.position[i]) * this.calibration[i] * this.calibration[i]);
        }
        return sum;
    }

    public final void getRelativePosition(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.position[i];
        }
    }

    public final void getPhysicalRelativeCoordinates(double[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = (float)this.position[i] * this.calibration[i];
        }
    }
}

