/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.analysis;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class ChartUtils {
    public static final Image<RGBALegacyType> asImage(JFreeChart chart) {
        return ChartUtils.asImage(chart, -1, -1);
    }

    public static final Image<RGBALegacyType> asImage(JFreeChart chart, int width, int height) {
        ChartPanel panel = new ChartPanel(chart);
        Dimension d = panel.getPreferredSize();
        if (-1 == width && -1 == height) {
            width = d.width;
            height = d.height;
            panel.setSize(d);
        } else {
            panel.setSize(width, height);
        }
        ChartUtils.layoutComponent((Component)panel);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        if (!panel.isOpaque()) {
            g.setColor(panel.getBackground());
            g.fillRect(0, 0, width, height);
        }
        panel.paint((Graphics)g);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(bi, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        g.dispose();
        Array<RGBALegacyType, IntArray> a = new Array<RGBALegacyType, IntArray>(new ArrayContainerFactory(), new IntArray(pixels), new int[]{width, height}, 1);
        RGBALegacyType linkedType = new RGBALegacyType(a);
        a.setLinkedType(linkedType);
        return new Image<RGBALegacyType>(a, new RGBALegacyType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void layoutComponent(Component c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            c.doLayout();
            if (c instanceof Container) {
                for (Component child : ((Container)c).getComponents()) {
                    ChartUtils.layoutComponent(child);
                }
            }
        }
        c.validate();
    }
}

