/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.math.fn;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.fn.FloatImageOperation;
import script.imglib.math.fn.IFunction;
import script.imglib.math.fn.ImageFunction;
import script.imglib.math.fn.NumberFunction;
import script.imglib.math.fn.Util;

public abstract class BinaryOperation
extends FloatImageOperation {
    private final IFunction a;
    private final IFunction b;

    public BinaryOperation(Image<? extends RealType<?>> left, Image<? extends RealType<?>> right) {
        this.a = new ImageFunction(left);
        this.b = new ImageFunction(right);
    }

    public BinaryOperation(IFunction fn, Image<? extends RealType<?>> right) {
        this.a = fn;
        this.b = new ImageFunction(right);
    }

    public BinaryOperation(Image<? extends RealType<?>> left, IFunction fn) {
        this.a = new ImageFunction(left);
        this.b = fn;
    }

    public BinaryOperation(IFunction fn1, IFunction fn2) {
        this.a = fn1;
        this.b = fn2;
    }

    public BinaryOperation(Image<? extends RealType<?>> left, Number val) {
        this.a = new ImageFunction(left);
        this.b = new NumberFunction(val);
    }

    public BinaryOperation(Number val, Image<? extends RealType<?>> right) {
        this.a = new NumberFunction(val);
        this.b = new ImageFunction(right);
    }

    public BinaryOperation(IFunction fn, Number val) {
        this.a = fn;
        this.b = new NumberFunction(val);
    }

    public BinaryOperation(Number val, IFunction fn) {
        this.a = new NumberFunction(val);
        this.b = fn;
    }

    public BinaryOperation(Number val1, Number val2) {
        this.a = new NumberFunction(val1);
        this.b = new NumberFunction(val2);
    }

    public BinaryOperation(Object ... elem) throws Exception {
        this.a = Util.wrap(elem[0]);
        IFunction right = Util.wrap(elem[elem.length - 1]);
        for (int i = elem.length - 2; i > 0; --i) {
            IFunction fn;
            right = fn = (IFunction)this.getClass().getConstructor(IFunction.class, IFunction.class).newInstance(Util.wrap(elem[i]), right);
        }
        this.b = right;
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> cursors) {
        this.a.findCursors(cursors);
        this.b.findCursors(cursors);
    }

    public final IFunction a() {
        return this.a;
    }

    public final IFunction b() {
        return this.b;
    }

    @Override
    public IFunction duplicate() throws Exception {
        return (IFunction)this.getClass().getConstructor(IFunction.class, IFunction.class).newInstance(this.a.duplicate(), this.b.duplicate());
    }
}

