/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.roi.AbstractRegionOfInterest;
import net.imglib2.roi.IterableRegionOfInterest;
import net.imglib2.type.Type;

@Deprecated
public abstract class AbstractIterableRegionOfInterest
extends AbstractRegionOfInterest
implements IterableRegionOfInterest {
    private static final long SIZE_NOT_CACHED = -1L;
    private long cached_size = -1L;
    private long[] cached_min;
    private long[] cached_max;

    protected AbstractIterableRegionOfInterest(int nDimensions) {
        super(nDimensions);
    }

    protected abstract boolean nextRaster(long[] var1, long[] var2);

    protected boolean nextRaster(long[] position, long[] end, Interval interval) {
        block0: while (this.nextRaster(position, end)) {
            int i;
            for (i = 0; i < position.length; ++i) {
                if (position[i] > interval.max(i)) continue block0;
            }
            for (i = 1; i < position.length; ++i) {
                if (position[i] < interval.min(i)) continue block0;
            }
            if (end[0] <= interval.min(0)) continue;
            position[0] = Math.max(position[0], interval.min(0));
            end[0] = Math.min(end[0], interval.max(0) + 1L);
            return true;
        }
        return false;
    }

    protected boolean jumpFwd(long totalSteps, long[] position, long[] end, Interval interval) {
        long steps = totalSteps;
        do {
            if (position[0] + steps < end[0]) {
                position[0] = position[0] + steps;
                return true;
            }
            steps -= end[0] - position[0];
            position[0] = end[0];
        } while (!(interval != null ? !this.nextRaster(position, end, interval) : !this.nextRaster(position, end)));
        return false;
    }

    @Override
    public <T extends Type<T>> IterableInterval<T> getIterableIntervalOverROI(RandomAccessible<T> src) {
        if (src instanceof RandomAccessibleInterval) {
            return new AROIClippedIterableInterval((RandomAccessibleInterval)src);
        }
        return new AROIIterableInterval<T>(src);
    }

    protected long size() {
        long[] position = new long[this.numDimensions()];
        long[] end = new long[this.numDimensions()];
        Arrays.fill(position, Long.MIN_VALUE);
        long accumulator = 0L;
        while (this.nextRaster(position, end)) {
            accumulator += end[0] - position[0];
            position[0] = end[0];
        }
        return accumulator;
    }

    protected void getExtrema(long[] minima, long[] maxima) {
        long[] position = new long[this.numDimensions()];
        long[] end = new long[this.numDimensions()];
        Arrays.fill(position, Long.MIN_VALUE);
        Arrays.fill(minima, Long.MAX_VALUE);
        Arrays.fill(maxima, Long.MIN_VALUE);
        while (this.nextRaster(position, end)) {
            for (int i = 0; i < position.length; ++i) {
                minima[i] = Math.min(minima[i], position[i]);
                maxima[i] = i == 0 ? Math.max(maxima[i], end[i] - 1L) : Math.max(maxima[i], position[i]);
            }
            position[0] = end[0];
        }
    }

    @Override
    protected void invalidateCachedState() {
        super.invalidateCachedState();
        this.cached_min = null;
        this.cached_max = null;
        this.cached_size = -1L;
    }

    @Override
    protected void getRealExtrema(double[] minima, double[] maxima) {
        this.validateExtremaCache();
        for (int i = 0; i < this.numDimensions(); ++i) {
            minima[i] = this.cached_min[i];
            maxima[i] = this.cached_max[i];
        }
    }

    protected void remove(long[] position) {
    }

    private void validateExtremaCache() {
        if (this.cached_max == null) {
            long[] min = new long[this.numDimensions()];
            long[] max = new long[this.numDimensions()];
            this.getExtrema(min, max);
            this.cached_min = min;
            this.cached_max = max;
        }
    }

    protected long getCachedSize() {
        if (this.cached_size == -1L) {
            this.cached_size = this.size();
        }
        return this.cached_size;
    }

    protected long dimension(int d) {
        this.validateExtremaCache();
        return this.cached_max[d] - this.cached_min[d] + 1L;
    }

    protected void dimensions(long[] d) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.dimension(i);
        }
    }

    protected void max(long[] max) {
        this.validateExtremaCache();
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.cached_max[i];
        }
    }

    protected void max(Positionable max) {
        this.validateExtremaCache();
        max.setPosition(this.cached_max);
    }

    protected long max(int d) {
        this.validateExtremaCache();
        return this.cached_max[d];
    }

    protected void min(long[] min) {
        this.validateExtremaCache();
        for (int i = 0; i < min.length; ++i) {
            min[i] = this.cached_min[i];
        }
    }

    protected void min(Positionable min) {
        this.validateExtremaCache();
        min.setPosition(this.cached_min);
    }

    protected long min(int d) {
        this.validateExtremaCache();
        return this.cached_min[d];
    }

    protected class AROIClippedIterableInterval<T extends Type<T>>
    extends AROIIterableInterval<T> {
        public AROIClippedIterableInterval(RandomAccessibleInterval<T> src) {
            super(src);
        }

        protected Interval getSrcInterval() {
            return (Interval)this.src;
        }

        @Override
        public double realMin(int d) {
            return Math.max(super.realMin(d), this.getSrcInterval().realMin(d));
        }

        @Override
        public void realMin(double[] min) {
            for (int i = 0; i < min.length; ++i) {
                min[i] = this.realMin(i);
            }
        }

        @Override
        public void realMin(RealPositionable min) {
            for (int i = 0; i < min.numDimensions(); ++i) {
                min.setPosition(this.realMin(i), i);
            }
        }

        @Override
        public double realMax(int d) {
            return Math.min(super.realMax(d), this.getSrcInterval().realMax(d));
        }

        @Override
        public void realMax(double[] max) {
            for (int i = 0; i < max.length; ++i) {
                max[i] = this.realMax(i);
            }
        }

        @Override
        public void realMax(RealPositionable max) {
            for (int i = 0; i < max.numDimensions(); ++i) {
                max.setPosition(this.realMax(i), i);
            }
        }

        @Override
        public long min(int d) {
            return Math.max(super.min(d), this.getSrcInterval().min(d));
        }

        @Override
        public void min(long[] min) {
            for (int i = 0; i < min.length; ++i) {
                min[i] = this.min(i);
            }
        }

        @Override
        public void min(Positionable min) {
            for (int i = 0; i < min.numDimensions(); ++i) {
                min.setPosition(this.min(i), i);
            }
        }

        @Override
        public long max(int d) {
            return Math.min(super.max(d), this.getSrcInterval().max(d));
        }

        @Override
        public void max(long[] max) {
            for (int i = 0; i < max.length; ++i) {
                max[i] = this.max(i);
            }
        }

        @Override
        public void max(Positionable max) {
            for (int i = 0; i < max.numDimensions(); ++i) {
                max.setPosition(this.max(i), i);
            }
        }
    }

    protected class AROIIterableInterval<T extends Type<T>>
    implements IterableInterval<T> {
        protected RandomAccessible<T> src;
        protected T cached_first_element;

        public AROIIterableInterval(RandomAccessible<T> src) {
            this.src = src;
        }

        public long size() {
            return AbstractIterableRegionOfInterest.this.getCachedSize();
        }

        public T getType() {
            return (T)((Type)this.src.getType());
        }

        public T firstElement() {
            if (this.cached_first_element == null) {
                RandomAccess r = this.src.randomAccess();
                long[] position = new long[this.numDimensions()];
                long[] raster_end = new long[this.numDimensions()];
                Arrays.fill(position, Long.MIN_VALUE);
                Arrays.fill(raster_end, Long.MIN_VALUE);
                boolean hasNext = this.src instanceof Interval ? AbstractIterableRegionOfInterest.this.nextRaster(position, raster_end, (Interval)this.src) : AbstractIterableRegionOfInterest.this.nextRaster(position, raster_end);
                if (!hasNext) {
                    throw new IllegalAccessError("Tried to get first element, but ROI has no elements");
                }
                r.setPosition(position);
                this.cached_first_element = (Type)r.get();
            }
            return this.cached_first_element;
        }

        public Object iterationOrder() {
            return new AROIIterationOrder();
        }

        public double realMin(int d) {
            return AbstractIterableRegionOfInterest.this.realMin(d);
        }

        public void realMin(double[] min) {
            AbstractIterableRegionOfInterest.this.realMin(min);
        }

        public void realMin(RealPositionable min) {
            AbstractIterableRegionOfInterest.this.realMin(min);
        }

        public double realMax(int d) {
            return AbstractIterableRegionOfInterest.this.realMax(d);
        }

        public void realMax(double[] max) {
            AbstractIterableRegionOfInterest.this.realMax(max);
        }

        public void realMax(RealPositionable max) {
            AbstractIterableRegionOfInterest.this.realMax(max);
        }

        public int numDimensions() {
            return AbstractIterableRegionOfInterest.this.numDimensions();
        }

        public Iterator<T> iterator() {
            return new AROICursor();
        }

        public long min(int d) {
            return AbstractIterableRegionOfInterest.this.min(d);
        }

        public void min(long[] min) {
            AbstractIterableRegionOfInterest.this.min(min);
        }

        public void min(Positionable min) {
            AbstractIterableRegionOfInterest.this.min(min);
        }

        public long max(int d) {
            return AbstractIterableRegionOfInterest.this.max(d);
        }

        public void max(long[] max) {
            AbstractIterableRegionOfInterest.this.max(max);
        }

        public void max(Positionable max) {
            AbstractIterableRegionOfInterest.this.max(max);
        }

        public void dimensions(long[] dimensions) {
            AbstractIterableRegionOfInterest.this.dimensions(dimensions);
        }

        public long dimension(int d) {
            return AbstractIterableRegionOfInterest.this.dimension(d);
        }

        public Cursor<T> cursor() {
            return new AROICursor();
        }

        public Cursor<T> localizingCursor() {
            return new AROICursor();
        }

        protected class AROICursor
        implements Cursor<T> {
            private RandomAccess<T> randomAccess;
            private final long[] position;
            private final long[] next_position;
            private final long[] raster_end;
            private final long[] next_raster_end;
            private boolean next_is_valid;
            private boolean has_next;
            private boolean src_is_valid;

            private void mark_dirty() {
                this.next_is_valid = false;
                this.src_is_valid = false;
            }

            protected AROICursor(AROICursor cursor) {
                this.randomAccess = AROIIterableInterval.this.src.randomAccess();
                this.position = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.next_position = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.raster_end = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.next_raster_end = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.next_is_valid = false;
                this.src_is_valid = false;
                this.randomAccess = cursor.randomAccess.copyRandomAccess();
                for (int d = 0; d < this.position.length; ++d) {
                    this.position[d] = cursor.position[d];
                    this.next_position[d] = cursor.next_position[d];
                    this.raster_end[d] = cursor.raster_end[d];
                    this.next_raster_end[d] = cursor.next_raster_end[d];
                    this.next_is_valid = cursor.next_is_valid;
                    this.has_next = cursor.has_next;
                    this.src_is_valid = cursor.src_is_valid;
                }
            }

            public AROICursor() {
                this.randomAccess = AROIIterableInterval.this.src.randomAccess();
                this.position = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.next_position = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.raster_end = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.next_raster_end = new long[AbstractIterableRegionOfInterest.this.numDimensions()];
                this.next_is_valid = false;
                this.src_is_valid = false;
                this.reset();
            }

            public void localize(float[] pos) {
                for (int d = 0; d < pos.length; ++d) {
                    pos[d] = this.position[d];
                }
            }

            public void localize(double[] pos) {
                for (int d = 0; d < pos.length; ++d) {
                    pos[d] = this.position[d];
                }
            }

            public void localize(int[] pos) {
                for (int d = 0; d < pos.length; ++d) {
                    pos[d] = (int)this.position[d];
                }
            }

            public void localize(long[] pos) {
                for (int d = 0; d < pos.length; ++d) {
                    pos[d] = this.position[d];
                }
            }

            public float getFloatPosition(int dim) {
                return this.position[dim];
            }

            public double getDoublePosition(int dim) {
                return this.position[dim];
            }

            public int getIntPosition(int dim) {
                return (int)this.position[dim];
            }

            public long getLongPosition(int dim) {
                return this.position[dim];
            }

            public int numDimensions() {
                return AbstractIterableRegionOfInterest.this.numDimensions();
            }

            public T get() {
                if (!this.src_is_valid) {
                    this.randomAccess.setPosition(this.position);
                }
                return (Type)this.randomAccess.get();
            }

            public T getType() {
                return (Type)this.randomAccess.getType();
            }

            public void jumpFwd(long steps) {
                Interval interval;
                Interval interval2 = interval = AROIIterableInterval.this.src instanceof Interval ? (Interval)AROIIterableInterval.this.src : null;
                if (!AbstractIterableRegionOfInterest.this.jumpFwd(steps, this.position, this.raster_end, interval)) {
                    throw new IllegalAccessError("Jumped past end of sequence");
                }
                this.mark_dirty();
            }

            public void fwd() {
                if (!this.hasNext()) {
                    throw new IllegalAccessError("fwd called at end of sequence");
                }
                for (int i = 0; i < this.position.length; ++i) {
                    this.position[i] = this.next_position[i];
                    this.raster_end[i] = this.next_raster_end[i];
                }
                this.mark_dirty();
            }

            public void reset() {
                for (long[] a : new long[][]{this.position, this.next_position, this.raster_end, this.next_raster_end}) {
                    Arrays.fill(a, Long.MIN_VALUE);
                }
                this.next_raster_end[0] = this.next_raster_end[0] + 1L;
                this.mark_dirty();
            }

            public boolean hasNext() {
                if (!this.next_is_valid) {
                    Interval interval = AROIIterableInterval.this.src instanceof Interval ? (Interval)AROIIterableInterval.this.src : null;
                    this.has_next = AbstractIterableRegionOfInterest.this.jumpFwd(1L, this.next_position, this.next_raster_end, interval);
                }
                this.next_is_valid = true;
                return this.has_next;
            }

            public T next() {
                this.fwd();
                return this.get();
            }

            public void remove() {
                AbstractIterableRegionOfInterest.this.remove(this.position);
                this.mark_dirty();
            }

            public AROICursor copy() {
                return new AROICursor(this);
            }

            public AROICursor copyCursor() {
                return this.copy();
            }
        }
    }

    protected class AROIIterationOrder {
        protected AROIIterationOrder() {
        }

        private AbstractIterableRegionOfInterest getEnclosingClass() {
            return AbstractIterableRegionOfInterest.this;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AROIIterationOrder)) {
                return false;
            }
            AROIIterationOrder o = (AROIIterationOrder)obj;
            return o.getEnclosingClass() == this.getEnclosingClass();
        }
    }
}

