/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Mask;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.Masks;
import net.imglib2.roi.PositionableIterableRegion;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.roi.util.IterableRegionOnBooleanRAI;
import net.imglib2.roi.util.PositionableWrappedIterableRegion;
import net.imglib2.roi.util.SamplingIterableInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.view.Views;

public class Regions {
    public static <T> IterableInterval<T> sample(IterableInterval<Void> region, RandomAccessible<T> img) {
        return SamplingIterableInterval.create(region, img);
    }

    public static <T> IterableInterval<T> sample(IterableRegion<?> region, RandomAccessible<T> img) {
        return Regions.sample(region.inside(), img);
    }

    public static <T> IterableInterval<T> sample(MaskInterval mask, RandomAccessible<T> img) {
        return Regions.sample(Masks.toIterableRegion(mask), img);
    }

    public static <T> IterableInterval<T> sample(RealMaskRealInterval mask, RandomAccessible<T> img) {
        return Regions.sample(Masks.toIterableRegion(mask), img);
    }

    public static <T, B extends BooleanType<B>> IterableInterval<T> sampleWithRandomAccessible(RandomAccessible<B> mask, RandomAccessibleInterval<T> img) {
        return Regions.sample(Regions.iterable(Views.interval(mask, img)), img);
    }

    public static <T> IterableInterval<T> sampleWithMask(Mask mask, RandomAccessibleInterval<T> img) {
        return Regions.sampleWithRandomAccessible(Masks.toRandomAccessible(mask), img);
    }

    public static <T> IterableInterval<T> sampleWithRealMask(RealMask mask, RandomAccessibleInterval<T> img) {
        return Regions.sampleWithRandomAccessible(Views.raster(Masks.toRealRandomAccessible(mask)), img);
    }

    public static <B extends BooleanType<B>> IterableRegion<B> iterable(RandomAccessibleInterval<B> region) {
        if (region instanceof IterableRegion) {
            return (IterableRegion)region;
        }
        return new IterableRegionOnBooleanRAI<B>(region);
    }

    public static <B extends BooleanType<B>> PositionableIterableRegion<B> positionable(RandomAccessibleInterval<B> region) {
        if (region instanceof PositionableIterableRegion) {
            return (PositionableIterableRegion)region;
        }
        return new PositionableWrappedIterableRegion<B>(Regions.iterable(region));
    }

    public static <B extends BooleanType<B>> long countTrue(RandomAccessibleInterval<B> interval) {
        long sum = 0L;
        for (BooleanType t : Views.iterable(interval)) {
            if (!t.get()) continue;
            ++sum;
        }
        return sum;
    }
}

