/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import ij.ImageJ;
import ij.ImagePlus;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.Type;
import net.imglib2.view.Views;
import org.janelia.thickness.lut.AbstractLUTRealTransform;

public class LUTRealTransform
extends AbstractLUTRealTransform {
    public LUTRealTransform(double[] lut, int numSourceDimensions, int numTargetDimensions) {
        super(lut, numSourceDimensions, numTargetDimensions);
    }

    public void apply(double[] source, double[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < source.length; ++d) {
            target[d] = this.applyChecked(source[d]);
        }
    }

    public void apply(float[] source, float[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < source.length; ++d) {
            target[d] = (float)this.applyChecked(source[d]);
        }
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimensions do not match.";
        int n = source.numDimensions();
        for (int d = 0; d < n; ++d) {
            target.setPosition(this.applyChecked(source.getDoublePosition(d)), d);
        }
    }

    public LUTRealTransform copy() {
        return new LUTRealTransform(this.lut, this.numSourceDimensions, this.numTargetDimensions);
    }

    public void applyInverse(double[] source, double[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < target.length; ++d) {
            source[d] = this.applyInverseChecked(target[d]);
        }
    }

    public void applyInverse(float[] source, float[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < target.length; ++d) {
            source[d] = (float)this.applyInverseChecked(target[d]);
        }
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimensions do not match.";
        int n = target.numDimensions();
        for (int d = 0; d < n; ++d) {
            source.setPosition(this.applyInverseChecked(target.getDoublePosition(d)), d);
        }
    }

    public InvertibleRealTransform inverse() {
        return new InverseRealTransform((InvertibleRealTransform)this);
    }

    public static <T extends Type<T>> void render(RealRandomAccessible<T> source, RandomAccessibleInterval<T> target, RealTransform transform, double dx) {
        RealRandomAccessible interpolant = Views.interpolate((EuclideanSpace)Views.extendBorder(target), (InterpolatorFactory)new NearestNeighborInterpolatorFactory());
        RealRandomAccess a = source.realRandomAccess();
        RealRandomAccess b = interpolant.realRandomAccess();
        for (double y = 0.0; y < (double)target.dimension(1); y += dx) {
            a.setPosition(y, 1);
            for (double x = 0.0; x < (double)target.dimension(0); x += dx) {
                a.setPosition(x, 0);
                transform.apply((RealLocalizable)a, (RealPositionable)b);
                ((Type)b.get()).set((Type)a.get());
            }
        }
    }

    public static final void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new ImagePlus("http://media.npr.org/images/picture-show-flickr-promo.jpg");
        imp.show();
        float[] pixels = (float[])imp.getProcessor().convertToFloat().getPixels();
        ArrayImg img = ArrayImgs.floats((float[])pixels, (long[])new long[]{imp.getWidth(), imp.getHeight()});
        double[] lut = new double[Math.max(imp.getWidth(), imp.getHeight())];
        for (int i = 0; i < lut.length; ++i) {
            lut[i] = (double)i + Math.pow(i, 1.5);
        }
        LUTRealTransform transform = new LUTRealTransform(lut, 2, 2);
        RealRandomAccessible source = Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)img), (InterpolatorFactory)new NLinearInterpolatorFactory());
        RealTransformRandomAccessible target = new RealTransformRandomAccessible(source, (RealTransform)transform);
        RealTransformRandomAccessible target2 = RealViews.transform((RealRandomAccessible)source, (InvertibleRealTransform)transform);
        ArrayImg targetImg = ArrayImgs.floats((long[])new long[]{imp.getWidth(), imp.getHeight()});
        LUTRealTransform.render(source, targetImg, (RealTransform)transform, 0.05);
        ImageJFunctions.show((RandomAccessibleInterval)Views.interval((RandomAccessible)target, (Interval)new FinalInterval(new long[]{imp.getWidth(), imp.getHeight()})));
        ImageJFunctions.show((RandomAccessibleInterval)Views.interval((RandomAccessible)target2, (Interval)new FinalInterval(new long[]{imp.getWidth(), imp.getHeight()})));
        ImageJFunctions.show((RandomAccessibleInterval)targetImg);
    }
}

