/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.type.numeric.real.DoubleType;
import org.janelia.thickness.lut.AbstractLUTRealTransformField;

public class LUTRealTransformField
extends AbstractLUTRealTransformField {
    public LUTRealTransformField(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> luts) {
        super(numSourceDimensions, numTargetDimensions, luts);
    }

    public LUTRealTransformField(double[] lut, int numSourceDimensions, int numTargetDimensions, long[] dimensions) {
        super(lut, numSourceDimensions, numTargetDimensions, dimensions);
    }

    public void apply(double[] source, double[] target) {
        target[0] = source[0];
        target[1] = source[1];
        for (int d = 2; d < source.length; ++d) {
            target[d] = this.applyChecked(source[d], (int)source[0], (int)source[1]);
        }
    }

    public void apply(float[] source, float[] target) {
        target[0] = source[0];
        target[1] = source[1];
        for (int d = 2; d < source.length; ++d) {
            target[d] = (float)this.applyChecked(source[d], (int)source[0], (int)source[1]);
        }
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        target.setPosition(source);
        for (int d = 2; d < source.numDimensions(); ++d) {
            target.setPosition(this.applyChecked(source.getDoublePosition(d), (int)source.getDoublePosition(0), (int)source.getDoublePosition(1)), d);
        }
    }

    public void applyInverse(double[] source, double[] target) {
        source[0] = target[0];
        source[1] = target[1];
        for (int d = 2; d < target.length; ++d) {
            source[d] = this.applyInverseChecked(target[d], (int)target[0], (int)target[1]);
        }
    }

    public void applyInverse(float[] source, float[] target) {
        source[0] = target[0];
        source[1] = target[1];
        for (int d = 2; d < target.length; ++d) {
            source[d] = (float)this.applyInverseChecked(target[d], (int)target[0], (int)target[1]);
        }
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        source.setPosition(target);
        for (int d = 2; d < target.numDimensions(); ++d) {
            source.setPosition(this.applyInverseChecked(target.getDoublePosition(d), (int)target.getDoublePosition(0), (int)target.getDoublePosition(1)), d);
        }
    }

    public InvertibleRealTransform inverse() {
        return new InverseRealTransform((InvertibleRealTransform)this);
    }

    public InvertibleRealTransform copy() {
        return new LUTRealTransformField(this.numSourceDimensions, this.numTargetDimensions, (RandomAccessibleInterval<DoubleType>)this.luts);
    }
}

