/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.trakem2;

import java.util.concurrent.Callable;
import net.imglib2.util.RealSum;

public class RealSumARGBNCC
implements Callable<Double> {
    protected int[] ap;
    protected int[] bp;

    public RealSumARGBNCC(int[] ap, int[] bp) {
        this.ap = ap;
        this.bp = bp;
    }

    @Override
    public Double call() {
        RealSum sumA = new RealSum();
        RealSum sumAA = new RealSum();
        RealSum sumB = new RealSum();
        RealSum sumBB = new RealSum();
        RealSum sumAB = new RealSum();
        int n = 0;
        for (int i = 0; i < this.ap.length; ++i) {
            int ra = this.ap[i] >> 16 & 0xFF;
            int ga = this.ap[i] >> 8 & 0xFF;
            int ba = this.ap[i] & 0xFF;
            int rb = this.bp[i] >> 16 & 0xFF;
            int gb = this.bp[i] >> 8 & 0xFF;
            int bb = this.bp[i] & 0xFF;
            if (ra == 0 || ga == 0 || ba == 0 || rb == 0 || gb == 0 || bb == 0 || ra == 255 || ga == 255 || ba == 255 || rb == 255 || gb == 255 || bb == 255) continue;
            ++n;
            double va = 0.3 * (double)ra + 0.6 * (double)ga + 0.1 * (double)ba;
            double vb = 0.3 * (double)rb + 0.6 * (double)gb + 0.1 * (double)bb;
            sumA.add(va);
            sumAA.add(va * va);
            sumB.add(vb);
            sumBB.add(vb * vb);
            sumAB.add(va * vb);
        }
        double suma = sumA.getSum();
        double sumaa = sumAA.getSum();
        double sumb = sumB.getSum();
        double sumbb = sumBB.getSum();
        double sumab = sumAB.getSum();
        return ((double)n * sumab - suma * sumb) / Math.sqrt((double)n * sumaa - suma * suma) / Math.sqrt((double)n * sumbb - sumb * sumb);
    }
}

