/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

final class MouseWheelScrollListener
implements MouseWheelListener {
    private final JScrollPane pane;
    private int previousValue;
    private boolean parentSearched = false;
    private Component parent = null;

    public MouseWheelScrollListener(JScrollPane pane) {
        this.pane = pane;
        this.previousValue = pane.getVerticalScrollBar().getValue();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int limit;
        if (!this.parentSearched && !this.searchParentScrollPane()) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        JScrollBar bar = this.pane.getVerticalScrollBar();
        int n = limit = e.getWheelRotation() < 0 ? 0 : bar.getMaximum() - bar.getVisibleAmount();
        if (this.previousValue == limit && bar.getValue() == limit) {
            this.parent.dispatchEvent(SwingUtilities.convertMouseEvent(this.pane, e, this.parent));
        }
        this.previousValue = bar.getValue();
    }

    private boolean searchParentScrollPane() {
        this.parentSearched = true;
        Container parent = this.pane.getParent();
        while (!(parent instanceof JScrollPane)) {
            if (parent == null) {
                return false;
            }
            parent = parent.getParent();
        }
        this.parent = parent;
        return true;
    }
}

