/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.appearance;

import bdv.util.Prefs;
import java.util.Objects;
import javax.swing.UIManager;
import org.scijava.listeners.Listeners;

public class Appearance {
    public static UIManager.LookAndFeelInfo DONT_MODIFY_LOOK_AND_FEEL = new UIManager.LookAndFeelInfo("don't modify", null);
    private boolean showScaleBar = false;
    private boolean showScaleBarInMovie = false;
    private boolean showMultibox = true;
    private boolean showTextOverlay = true;
    private Prefs.OverlayPosition sourceNameOverlayPosition = Prefs.OverlayPosition.TOP_CENTER;
    private int scaleBarColor = -1;
    private int scaleBarBgColor = -2013265920;
    private UIManager.LookAndFeelInfo lookAndFeel = DONT_MODIFY_LOOK_AND_FEEL;
    private final Listeners.List<UpdateListener> updateListeners = new Listeners.SynchronizedList();

    public void set(Appearance other) {
        this.showScaleBar = other.showScaleBar;
        this.showScaleBarInMovie = other.showScaleBarInMovie;
        this.showMultibox = other.showMultibox;
        this.showTextOverlay = other.showTextOverlay;
        this.sourceNameOverlayPosition = other.sourceNameOverlayPosition;
        this.scaleBarColor = other.scaleBarColor;
        this.scaleBarBgColor = other.scaleBarBgColor;
        this.lookAndFeel = other.lookAndFeel;
        this.notifyListeners();
    }

    private void notifyListeners() {
        this.updateListeners.list.forEach(UpdateListener::appearanceChanged);
    }

    public Listeners<UpdateListener> updateListeners() {
        return this.updateListeners;
    }

    public boolean showScaleBar() {
        return this.showScaleBar;
    }

    public void setShowScaleBar(boolean showScaleBar) {
        if (this.showScaleBar != showScaleBar) {
            this.showScaleBar = showScaleBar;
            this.notifyListeners();
        }
    }

    public boolean showScaleBarInMovie() {
        return this.showScaleBarInMovie;
    }

    public void setShowScaleBarInMovie(boolean showScaleBarInMovie) {
        if (this.showScaleBarInMovie != showScaleBarInMovie) {
            this.showScaleBarInMovie = showScaleBarInMovie;
            this.notifyListeners();
        }
    }

    public boolean showMultibox() {
        return this.showMultibox;
    }

    public void setShowMultibox(boolean showMultibox) {
        if (this.showMultibox != showMultibox) {
            this.showMultibox = showMultibox;
            this.notifyListeners();
        }
    }

    public boolean showTextOverlay() {
        return this.showTextOverlay;
    }

    public void setShowTextOverlay(boolean showTextOverlay) {
        if (this.showTextOverlay != showTextOverlay) {
            this.showTextOverlay = showTextOverlay;
            this.notifyListeners();
        }
    }

    public Prefs.OverlayPosition sourceNameOverlayPosition() {
        return this.sourceNameOverlayPosition;
    }

    public void setSourceNameOverlayPosition(Prefs.OverlayPosition sourceNameOverlayPosition) {
        if (this.sourceNameOverlayPosition != sourceNameOverlayPosition) {
            this.sourceNameOverlayPosition = sourceNameOverlayPosition;
            this.notifyListeners();
        }
    }

    public int scaleBarColor() {
        return this.scaleBarColor;
    }

    public void setScaleBarColor(int scaleBarColor) {
        if (this.scaleBarColor != scaleBarColor) {
            this.scaleBarColor = scaleBarColor;
            this.notifyListeners();
        }
    }

    public int scaleBarBgColor() {
        return this.scaleBarBgColor;
    }

    public void setScaleBarBgColor(int scaleBarBgColor) {
        if (this.scaleBarBgColor != scaleBarBgColor) {
            this.scaleBarBgColor = scaleBarBgColor;
            this.notifyListeners();
        }
    }

    public UIManager.LookAndFeelInfo lookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(UIManager.LookAndFeelInfo lookAndFeel) {
        if (!Objects.equals(this.lookAndFeel, lookAndFeel)) {
            this.lookAndFeel = lookAndFeel;
            this.notifyListeners();
        }
    }

    public static UIManager.LookAndFeelInfo currentLookAndFeelInfo() {
        return Appearance.lookAndFeelInfoForName(UIManager.getLookAndFeel().getName());
    }

    public static UIManager.LookAndFeelInfo lookAndFeelInfoForName(String name) {
        if (name != null) {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!info.getName().equals(name)) continue;
                return info;
            }
        }
        return DONT_MODIFY_LOOK_AND_FEEL;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Appearance{");
        sb.append("showScaleBar=").append(this.showScaleBar);
        sb.append(", showScaleBarInMovie=").append(this.showScaleBarInMovie);
        sb.append(", showMultibox=").append(this.showMultibox);
        sb.append(", showTextOverlay=").append(this.showTextOverlay);
        sb.append(", sourceNameOverlayPosition=").append((Object)this.sourceNameOverlayPosition);
        sb.append(", scaleBarColor=").append(this.scaleBarColor);
        sb.append(", scaleBarBgColor=").append(this.scaleBarBgColor);
        sb.append(", lookAndFeel=").append(this.lookAndFeel);
        sb.append('}');
        return sb.toString();
    }

    public static interface UpdateListener {
        public void appearanceChanged();
    }
}

