/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.appearance;

import bdv.ui.appearance.Appearance;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.appearance.StyleElements;
import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import bdv.util.Prefs;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.scijava.listeners.Listeners;

public class AppearanceSettingsPage
implements SettingsPage {
    private final String treePath;
    private final AppearanceManager manager;
    private final Listeners.List<ModificationListener> modificationListeners;
    private final Appearance editedAppearance;
    private final JPanel panel;

    public AppearanceSettingsPage(AppearanceManager manager) {
        this("Appearance", manager);
    }

    public AppearanceSettingsPage(String treePath, AppearanceManager manager) {
        this.treePath = treePath;
        this.manager = manager;
        this.editedAppearance = new Appearance();
        this.editedAppearance.set(manager.appearance());
        this.panel = new AppearancePanel(this.editedAppearance);
        this.modificationListeners = new Listeners.SynchronizedList();
        this.editedAppearance.updateListeners().add(() -> this.modificationListeners.list.forEach(l -> l.setModified()));
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public Listeners<ModificationListener> modificationListeners() {
        return this.modificationListeners;
    }

    @Override
    public void cancel() {
        this.editedAppearance.set(this.manager.appearance());
    }

    @Override
    public void apply() {
        this.manager.appearance().set(this.editedAppearance);
        this.manager.save();
        this.manager.toPrefs();
        this.manager.updateLookAndFeel();
    }

    static class AppearancePanel
    extends JPanel {
        public AppearancePanel(Appearance appearance) {
            super((LayoutManager)new MigLayout("fillx", "[r][l]", ""));
            ArrayList lafs = new ArrayList();
            lafs.add(StyleElements.cbentry(Appearance.DONT_MODIFY_LOOK_AND_FEEL, "don't set"));
            for (UIManager.LookAndFeelInfo feel : UIManager.getInstalledLookAndFeels()) {
                lafs.add(StyleElements.cbentry(feel, feel.getName()));
            }
            StyleElements.StyleElement[] styleElementArray = new StyleElements.StyleElement[10];
            styleElementArray[0] = StyleElements.comboBoxElement("look-and-feel", appearance::lookAndFeel, appearance::setLookAndFeel, lafs);
            styleElementArray[1] = StyleElements.separator();
            styleElementArray[2] = StyleElements.booleanElement("show scalebar", appearance::showScaleBar, appearance::setShowScaleBar);
            styleElementArray[3] = StyleElements.booleanElement("show scalebar in movies", appearance::showScaleBarInMovie, appearance::setShowScaleBarInMovie);
            styleElementArray[4] = StyleElements.colorElement("scalebar foreground", appearance::scaleBarColor, appearance::setScaleBarColor);
            styleElementArray[5] = StyleElements.colorElement("scalebar background", appearance::scaleBarBgColor, appearance::setScaleBarBgColor);
            styleElementArray[6] = StyleElements.separator();
            styleElementArray[7] = StyleElements.booleanElement("show minimap", appearance::showMultibox, appearance::setShowMultibox);
            styleElementArray[8] = StyleElements.booleanElement("show source info", appearance::showTextOverlay, appearance::setShowTextOverlay);
            styleElementArray[9] = StyleElements.comboBoxElement((String)"source name position", appearance::sourceNameOverlayPosition, appearance::setSourceNameOverlayPosition, (Enum[])Prefs.OverlayPosition.values());
            List<StyleElements.StyleElement> styleElements = Arrays.asList(styleElementArray);
            final JColorChooser colorChooser = new JColorChooser();
            styleElements.forEach(element -> element.accept(new StyleElements.StyleElementVisitor(){

                @Override
                public void visit(StyleElements.Separator separator) {
                    this.add(Box.createVerticalStrut(10), "growx, span 2, wrap");
                }

                @Override
                public void visit(StyleElements.ColorElement element) {
                    this.add((Component)new JLabel(element.getLabel()), "r");
                    this.add((Component)StyleElements.linkedColorButton(element, colorChooser), "l, wrap");
                }

                @Override
                public void visit(StyleElements.BooleanElement element) {
                    this.add((Component)new JLabel(element.getLabel()), "r");
                    this.add((Component)StyleElements.linkedCheckBox(element), "l, wrap");
                }

                @Override
                public void visit(StyleElements.ComboBoxElement<?> element) {
                    this.add((Component)new JLabel(element.getLabel()), "r");
                    this.add(StyleElements.linkedComboBox(element), "l, wrap");
                }
            }));
            appearance.updateListeners().add(() -> {
                styleElements.forEach(StyleElements.StyleElement::update);
                this.repaint();
            });
        }
    }
}

