/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.settings;

import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.scijava.listeners.Listeners;

public class SimpleSettingsPage
implements SettingsPage {
    private final String treePath;
    private final JPanel panel;
    private final Listeners.List<ModificationListener> modificationListeners;
    protected final ArrayList<Runnable> runOnApply = new ArrayList();
    protected final ArrayList<Runnable> runOnCancel = new ArrayList();

    public SimpleSettingsPage(String treePath, JPanel panel) {
        this.treePath = treePath;
        this.panel = panel;
        this.modificationListeners = new Listeners.SynchronizedList();
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    public void notifyModified() {
        this.modificationListeners.list.forEach(ModificationListener::setModified);
    }

    @Override
    public Listeners<ModificationListener> modificationListeners() {
        return this.modificationListeners;
    }

    public synchronized void onApply(Runnable runnable) {
        this.runOnApply.add(runnable);
    }

    public synchronized void onCancel(Runnable runnable) {
        this.runOnCancel.add(runnable);
    }

    @Override
    public void cancel() {
        this.runOnCancel.forEach(Runnable::run);
    }

    @Override
    public void apply() {
        this.runOnApply.forEach(Runnable::run);
    }
}

