/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.viewermodepanel;

import bdv.ui.UIUtils;
import bdv.ui.viewermodepanel.LabeledToggleButton;
import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class DisplaySettingsPanel
extends JPanel {
    private static final String SINGLE_MODE_TOOL_TIP = "<html><b>Single</b>/Fused</html>";
    private static final String FUSED_MODE_TOOL_TIP = "<html>Single/<b>Fused</b></html>";
    private static final String GROUP_MODE_TOOL_TIP = "<html>Source/<b>Group</b></html>";
    private static final String SOURCE_MODE_TOOL_TIP = "<html><b>Source</b>/Group</html>";
    private static final String NEAREST_INTERPOLATION_TOOL_TIP = "<html><b>Nearest</b>/Linear</html>";
    private static final String LINEAR_INTERPOLATION_TOOL_TIP = "<html>Nearest/<b>Linear</b></html>";
    private final LabeledToggleButton fusion;
    private final LabeledToggleButton grouping;
    private final LabeledToggleButton interpolation;

    public DisplaySettingsPanel(ViewerState state) {
        super((LayoutManager)new MigLayout("ins 2 0 0 0, fillx, filly", "[][][]", "top"));
        String isDark = UIUtils.isDark("Panel.background") ? "_dark" : "";
        String isLarge = UIUtils.getUIScaleFactor(this) > 1.5 ? "_200" : "";
        this.fusion = new LabeledToggleButton(new ImageIcon(this.getClass().getResource("single_mode" + isDark + isLarge + ".png")), new ImageIcon(this.getClass().getResource("fusion_mode" + isDark + isLarge + ".png")), " Single", " Fused ", SINGLE_MODE_TOOL_TIP, FUSED_MODE_TOOL_TIP);
        this.grouping = new LabeledToggleButton(new ImageIcon(this.getClass().getResource("source_mode" + isDark + isLarge + ".png")), new ImageIcon(this.getClass().getResource("grouping_mode" + isDark + isLarge + ".png")), " Source", " Group ", SOURCE_MODE_TOOL_TIP, GROUP_MODE_TOOL_TIP);
        this.interpolation = new LabeledToggleButton(new ImageIcon(this.getClass().getResource("nearest" + isDark + isLarge + ".png")), new ImageIcon(this.getClass().getResource("linear" + isDark + isLarge + ".png")), " Nearest", " Linear ", NEAREST_INTERPOLATION_TOOL_TIP, LINEAR_INTERPOLATION_TOOL_TIP);
        this.fusion.setSelected(state.getDisplayMode().hasFused());
        this.grouping.setSelected(state.getDisplayMode().hasGrouping());
        this.interpolation.setSelected(state.getInterpolation() == Interpolation.NLINEAR);
        state.changeListeners().add(e -> {
            if (e == ViewerStateChange.DISPLAY_MODE_CHANGED) {
                DisplayMode displayMode = state.getDisplayMode();
                SwingUtilities.invokeLater(() -> {
                    this.fusion.setSelected(displayMode.hasFused());
                    this.grouping.setSelected(displayMode.hasGrouping());
                });
            } else if (e == ViewerStateChange.INTERPOLATION_CHANGED) {
                Interpolation interpolationMode = state.getInterpolation();
                SwingUtilities.invokeLater(() -> this.interpolation.setSelected(interpolationMode == Interpolation.NLINEAR));
            }
        });
        this.fusion.addActionListener(e -> state.setDisplayMode(state.getDisplayMode().withFused(this.fusion.isSelected())));
        this.grouping.addActionListener(e -> state.setDisplayMode(state.getDisplayMode().withGrouping(this.grouping.isSelected())));
        this.interpolation.addActionListener(e -> state.setInterpolation(this.interpolation.isSelected() ? Interpolation.NLINEAR : Interpolation.NEARESTNEIGHBOR));
        this.add(this.fusion);
        this.add(this.grouping);
        this.add(this.interpolation);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Panel.background"));
        if (this.fusion != null) {
            String isDark = UIUtils.isDark("Panel.background") ? "_dark" : "";
            String isLarge = UIUtils.getUIScaleFactor(this) > 1.5 ? "_200" : "";
            this.fusion.setIcons(new ImageIcon(this.getClass().getResource("single_mode" + isDark + isLarge + ".png")), new ImageIcon(this.getClass().getResource("fusion_mode" + isDark + isLarge + ".png")));
            this.grouping.setIcons(new ImageIcon(this.getClass().getResource("source_mode" + isDark + isLarge + ".png")), new ImageIcon(this.getClass().getResource("grouping_mode" + isDark + isLarge + ".png")));
            this.interpolation.setIcons(new ImageIcon(this.getClass().getResource("nearest" + isDark + isLarge + ".png")), new ImageIcon(this.getClass().getResource("linear" + isDark + isLarge + ".png")));
        }
    }
}

