/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.AbstractSource;
import bdv.util.AxisOrder;
import bdv.util.Bdv;
import bdv.util.BdvHandle;
import bdv.util.BdvHandleFrame;
import bdv.util.BdvOptions;
import bdv.util.BdvVirtualChannelSource;
import bdv.util.PlaceHolderConverterSetup;
import bdv.util.PlaceHolderOverlayInfo;
import bdv.util.RandomAccessibleIntervalSource;
import bdv.util.RandomAccessibleIntervalSource4D;
import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.TypeIdentity;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;

public class VirtualChannels {
    static List<BdvVirtualChannelSource> show(RandomAccessibleInterval<ARGBType> img, List<? extends VirtualChannel> virtualChannels, String name, BdvOptions options) {
        Bdv bdv = options.values.addTo();
        BdvHandle handle = bdv == null ? new BdvHandleFrame(options) : bdv.getBdvHandle();
        AffineTransform3D sourceTransform = options.values.getSourceTransform();
        AxisOrder axisOrder = options.values.axisOrder();
        ArrayList<RandomAccessibleInterval<ARGBType>> stacks = AxisOrder.splitInputStackIntoSourceStacks(img, axisOrder = AxisOrder.getAxisOrder(axisOrder, img, handle.is2D()));
        if (stacks.size() != 1) {
            throw new IllegalArgumentException("The RandomAccessibleInterval of a VirtualChannelSource must have exactly one channel!");
        }
        RandomAccessibleInterval<ARGBType> stack = stacks.get(0);
        ArrayList<BdvVirtualChannelSource> bdvSources = new ArrayList<BdvVirtualChannelSource>();
        int numTimepoints = stack.numDimensions() > 3 ? (int)stack.max(3) + 1 : 1;
        ChannelSourceCoordinator coordinator = new ChannelSourceCoordinator();
        for (VirtualChannel virtualChannel : virtualChannels) {
            AbstractSource source = stack.numDimensions() > 3 ? new ChannelSource4D(stack, coordinator, sourceTransform, name) : new DefaultChannelSource(stack, coordinator, sourceTransform, name);
            int setupId = handle.getUnusedSetupId();
            PlaceHolderConverterSetup setup = new PlaceHolderConverterSetup(setupId, 0.0, 255.0, new ARGBType(-1));
            SourceAndConverter<ARGBType> soc = source.getSourceAndConverter();
            handle.add(Collections.singletonList(setup), Collections.singletonList(soc), numTimepoints);
            PlaceHolderOverlayInfo info = new PlaceHolderOverlayInfo(handle.getViewerPanel(), soc, setup);
            coordinator.sharedInfos.add(info);
            setup.setupChangeListeners().add(s -> vc.updateSetupParameters());
            info.visibilityChangeListeners().add(virtualChannel::updateVisibility);
            BdvVirtualChannelSource bdvSource = new BdvVirtualChannelSource(handle, numTimepoints, setup, soc, info, coordinator);
            handle.addBdvSource(bdvSource);
            bdvSources.add(bdvSource);
        }
        return bdvSources;
    }

    static class ChannelSource4D
    extends RandomAccessibleIntervalSource4D<ARGBType>
    implements ChannelSource {
        private final ChannelSourceCoordinator coordinator;
        private final SourceAndConverter<ARGBType> soc;

        public ChannelSource4D(RandomAccessibleInterval<ARGBType> img, ChannelSourceCoordinator coordinator, AffineTransform3D sourceTransform, String name) {
            super(img, new ARGBType(), sourceTransform, name);
            this.coordinator = coordinator;
            this.soc = new SourceAndConverter<ARGBType>(this, new TypeIdentity<ARGBType>());
        }

        @Override
        public boolean isPresent(int t) {
            return super.isPresent(t) && this.coordinator.shouldBePresent(this);
        }

        @Override
        public SourceAndConverter<ARGBType> getSourceAndConverter() {
            return this.soc;
        }
    }

    static class DefaultChannelSource
    extends RandomAccessibleIntervalSource<ARGBType>
    implements ChannelSource {
        private final ChannelSourceCoordinator coordinator;
        private final SourceAndConverter<ARGBType> soc;

        public DefaultChannelSource(RandomAccessibleInterval<ARGBType> img, ChannelSourceCoordinator coordinator, AffineTransform3D sourceTransform, String name) {
            super(img, new ARGBType(), sourceTransform, name);
            this.coordinator = coordinator;
            this.soc = new SourceAndConverter<ARGBType>(this, new TypeIdentity<ARGBType>());
        }

        @Override
        public boolean isPresent(int t) {
            return super.isPresent(t) && this.coordinator.shouldBePresent(this);
        }

        @Override
        public SourceAndConverter<ARGBType> getSourceAndConverter() {
            return this.soc;
        }
    }

    static interface ChannelSource {
        public SourceAndConverter<ARGBType> getSourceAndConverter();
    }

    static class ChannelSourceCoordinator {
        List<PlaceHolderOverlayInfo> sharedInfos = new ArrayList<PlaceHolderOverlayInfo>();

        ChannelSourceCoordinator() {
        }

        boolean shouldBePresent(ChannelSource source) {
            for (PlaceHolderOverlayInfo info : this.sharedInfos) {
                if (!info.isVisible()) continue;
                return info.getSource().equals(source.getSourceAndConverter());
            }
            return false;
        }
    }

    public static interface VirtualChannel {
        public void updateVisibility();

        public void updateSetupParameters();
    }
}

