/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.state;

import bdv.util.MipmapTransforms;
import bdv.viewer.BasicViewerState;
import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.state.SourceState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.realtransform.AffineTransform3D;

@Deprecated
public class ViewerState {
    final SynchronizedViewerState state;
    final Map<SourceGroup, bdv.viewer.state.SourceGroup> handleToSourceGroup = new HashMap<SourceGroup, bdv.viewer.state.SourceGroup>();

    public SynchronizedViewerState getState() {
        return this.state;
    }

    public ViewerState(List<SourceAndConverter<?>> sources, int numTimePoints) {
        this(sources, new ArrayList<bdv.viewer.state.SourceGroup>(), numTimePoints);
    }

    public ViewerState(List<SourceAndConverter<?>> sources, List<bdv.viewer.state.SourceGroup> sourceGroups, int numTimePoints) {
        this.state = new SynchronizedViewerState(new BasicViewerState());
        this.state.addSources(sources);
        this.state.setSourcesActive(sources, true);
        sourceGroups.forEach(sourceGroup -> {
            SourceGroup handle = new SourceGroup();
            this.state.addGroup(handle);
            this.state.setGroupName(handle, sourceGroup.getName());
            this.state.setGroupActive(handle, sourceGroup.isActive());
            sourceGroup.getSourceIds().forEach(i -> this.state.addSourceToGroup((SourceAndConverter)sources.get((int)i), handle));
        });
        this.state.setNumTimepoints(numTimePoints);
        this.state.setViewerTransform(new AffineTransform3D());
        this.state.setInterpolation(Interpolation.NEARESTNEIGHBOR);
        this.state.setDisplayMode(DisplayMode.SINGLE);
        this.state.setCurrentSource(sources.isEmpty() ? null : sources.get(0));
        this.state.setCurrentGroup(this.state.getGroups().isEmpty() ? null : this.state.getGroups().get(0));
        this.state.setCurrentTimepoint(0);
    }

    public ViewerState(SynchronizedViewerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ViewerState(ViewerState s) {
        SynchronizedViewerState synchronizedViewerState = s.state;
        synchronized (synchronizedViewerState) {
            this.state = new SynchronizedViewerState(new BasicViewerState(s.state));
        }
    }

    public synchronized ViewerState copy() {
        return new ViewerState(this);
    }

    public void getViewerTransform(AffineTransform3D t) {
        this.state.getViewerTransform(t);
    }

    public void setViewerTransform(AffineTransform3D t) {
        this.state.setViewerTransform(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSource() {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            return this.state.getSources().indexOf(this.state.getCurrentSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSource(int index) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.setCurrentSource(this.state.getSources().get(index));
        }
    }

    public void setCurrentSource(Source<?> source) {
        this.state.setCurrentSource(this.soc(source));
    }

    private SourceAndConverter<?> soc(Source<?> source) {
        for (SourceAndConverter<?> soc : this.state.getSources()) {
            if (soc.getSpimSource() != source) continue;
            return soc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentGroup() {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            return this.state.getGroups().indexOf(this.state.getCurrentGroup());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentGroup(int index) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.setCurrentGroup(this.state.getGroups().get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentGroup(bdv.viewer.state.SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.setCurrentGroup(this.getHandle(group));
        }
    }

    private SourceGroup getHandle(bdv.viewer.state.SourceGroup group) {
        for (SourceGroup handle : this.state.getGroups()) {
            bdv.viewer.state.SourceGroup g = new bdv.viewer.state.SourceGroup(this.state.getGroupName(handle));
            this.state.getSourcesInGroup(handle).forEach(s -> g.addSource(this.state.getSources().indexOf(s)));
            if (!g.equals(group)) continue;
            return handle;
        }
        return null;
    }

    public Interpolation getInterpolation() {
        return this.state.getInterpolation();
    }

    public void setInterpolation(Interpolation method) {
        this.state.setInterpolation(method);
    }

    @Deprecated
    public boolean isSingleSourceMode() {
        return this.state.getDisplayMode() == DisplayMode.SINGLE;
    }

    @Deprecated
    public void setSingleSourceMode(boolean singleSourceMode) {
        if (singleSourceMode) {
            this.setDisplayMode(DisplayMode.SINGLE);
        } else {
            this.setDisplayMode(DisplayMode.FUSED);
        }
    }

    public void setDisplayMode(DisplayMode mode) {
        this.state.setDisplayMode(mode);
    }

    public DisplayMode getDisplayMode() {
        return this.state.getDisplayMode();
    }

    public int getCurrentTimepoint() {
        return this.state.getCurrentTimepoint();
    }

    public void setCurrentTimepoint(int timepoint) {
        this.state.setCurrentTimepoint(timepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SourceState<?>> getSources() {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            ArrayList sourceStates = new ArrayList();
            for (SourceAndConverter<?> source : this.state.getSources()) {
                SourceState ss = new SourceState(source, this);
                sourceStates.add(ss);
            }
            return sourceStates;
        }
    }

    public int numSources() {
        return this.state.getSources().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<bdv.viewer.state.SourceGroup> getSourceGroups() {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            ArrayList<bdv.viewer.state.SourceGroup> sourceGroups = new ArrayList<bdv.viewer.state.SourceGroup>();
            for (SourceGroup handle : this.state.getGroups()) {
                sourceGroups.add(this.handleToSourceGroup.computeIfAbsent(handle, h -> {
                    bdv.viewer.state.SourceGroup g = new bdv.viewer.state.SourceGroup(this.state, handle);
                    return g;
                }));
            }
            return sourceGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numSourceGroups() {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            return this.state.getGroups().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(SourceAndConverter<?> source) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.addSource(source);
            this.state.setSourceActive(source, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(Source<?> source) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.removeSource(this.soc(source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSource(int index) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.removeSource(this.state.getSources().get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(bdv.viewer.state.SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            SourceGroup handle = new SourceGroup();
            this.state.addGroup(handle);
            this.state.setGroupName(handle, group.getName());
            this.state.setGroupActive(handle, group.isActive());
            group.getSourceIds().forEach(i -> this.state.addSourceToGroup(this.state.getSources().get((int)i), handle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(bdv.viewer.state.SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.removeGroup(this.getHandle(group));
        }
    }

    protected void removeGroup(int index) {
        this.state.removeGroup(this.state.getGroups().get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceVisible(int index) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            return this.state.isSourceVisibleAndPresent(this.state.getSources().get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getVisibleSourceIndices() {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            ArrayList sources = new ArrayList(this.state.getVisibleAndPresentSources());
            sources.sort(this.state.sourceOrder());
            return sources.stream().map(this.state.getSources()::indexOf).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBestMipMapLevel(AffineTransform3D screenScaleTransform, int sourceIndex) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            return this.getBestMipMapLevel(screenScaleTransform, this.state.getSources().get(sourceIndex).getSpimSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBestMipMapLevel(AffineTransform3D screenScaleTransform, Source<?> source) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            AffineTransform3D screenTransform = new AffineTransform3D();
            this.getViewerTransform(screenTransform);
            screenTransform.preConcatenate(screenScaleTransform);
            return MipmapTransforms.getBestMipMapLevel(screenTransform, source, this.state.getCurrentTimepoint());
        }
    }

    public int getNumTimepoints() {
        return this.state.getNumTimepoints();
    }

    public void setNumTimepoints(int numTimepoints) {
        this.state.setNumTimepoints(numTimepoints);
    }

    public void kill() {
        this.state.clearGroups();
        this.state.clearSources();
    }
}

