/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.state;

import bdv.viewer.DisplayMode;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.state.SourceState;
import bdv.viewer.state.ViewerState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpicbg.spim.data.XmlHelpers;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoViewerState {
    public static final String VIEWERSTATE_TAG = "ViewerState";
    public static final String VIEWERSTATE_SOURCES_TAG = "Sources";
    public static final String VIEWERSTATE_SOURCE_TAG = "Source";
    public static final String VIEWERSTATE_SOURCE_ACTIVE_TAG = "active";
    public static final String VIEWERSTATE_GROUPS_TAG = "SourceGroups";
    public static final String VIEWERSTATE_GROUP_TAG = "SourceGroup";
    public static final String VIEWERSTATE_GROUP_ACTIVE_TAG = "active";
    public static final String VIEWERSTATE_GROUP_NAME_TAG = "name";
    public static final String VIEWERSTATE_GROUP_SOURCEID_TAG = "id";
    public static final String VIEWERSTATE_DISPLAYMODE_TAG = "DisplayMode";
    public static final String VIEWERSTATE_DISPLAYMODE_VALUE_SINGLE = "ss";
    public static final String VIEWERSTATE_DISPLAYMODE_VALUE_GROUP = "sg";
    public static final String VIEWERSTATE_DISPLAYMODE_VALUE_FUSED = "fs";
    public static final String VIEWERSTATE_DISPLAYMODE_VALUE_FUSEDGROUP = "fg";
    public static final String VIEWERSTATE_INTERPOLATION_TAG = "Interpolation";
    public static final String VIEWERSTATE_INTERPOLATION_VALUE_NEARESTNEIGHBOR = "nearestneighbor";
    public static final String VIEWERSTATE_INTERPOLATION_VALUE_NLINEAR = "nlinear";
    public static final String VIEWERSTATE_CURRENTSOURCE_TAG = "CurrentSource";
    public static final String VIEWERSTATE_CURRENTGROUP_TAG = "CurrentGroup";
    public static final String VIEWERSTATE_CURRENTTIMEPOINT_TAG = "CurrentTimePoint";

    public String getTagName() {
        return VIEWERSTATE_TAG;
    }

    public Element toXml(ViewerState state) {
        Element elem = new Element(VIEWERSTATE_TAG);
        elem.addContent((Content)this.sourcesToXml(state.getSources()));
        elem.addContent((Content)this.sourceGroupsToXml(state.getSourceGroups()));
        elem.addContent((Content)this.displayModeToXml(state.getDisplayMode()));
        elem.addContent((Content)this.interpolationModeToXml(state.getInterpolation()));
        elem.addContent((Content)XmlHelpers.intElement((String)VIEWERSTATE_CURRENTSOURCE_TAG, (int)state.getCurrentSource()));
        elem.addContent((Content)XmlHelpers.intElement((String)VIEWERSTATE_CURRENTGROUP_TAG, (int)state.getCurrentGroup()));
        elem.addContent((Content)XmlHelpers.intElement((String)VIEWERSTATE_CURRENTTIMEPOINT_TAG, (int)state.getCurrentTimepoint()));
        return elem;
    }

    public void restoreFromXml(Element elem, ViewerState state) {
        this.restoreSourcesFromXml(elem.getChild(VIEWERSTATE_SOURCES_TAG), state.getSources());
        this.restoreSourceGroupsFromXml(elem.getChild(VIEWERSTATE_GROUPS_TAG), state);
        state.setDisplayMode(this.displayModeFromXml(elem.getChild(VIEWERSTATE_DISPLAYMODE_TAG)));
        state.setInterpolation(this.interpolationModeFromXml(elem.getChild(VIEWERSTATE_INTERPOLATION_TAG)));
        state.setCurrentSource(XmlHelpers.getInt((Element)elem, (String)VIEWERSTATE_CURRENTSOURCE_TAG));
        state.setCurrentGroup(XmlHelpers.getInt((Element)elem, (String)VIEWERSTATE_CURRENTGROUP_TAG));
        state.setCurrentTimepoint(XmlHelpers.getInt((Element)elem, (String)VIEWERSTATE_CURRENTTIMEPOINT_TAG));
    }

    protected Element sourcesToXml(List<SourceState<?>> sources) {
        Element elem = new Element(VIEWERSTATE_SOURCES_TAG);
        for (SourceState<?> source : sources) {
            Element sourceElem = new Element(VIEWERSTATE_SOURCE_TAG);
            sourceElem.addContent((Content)XmlHelpers.booleanElement((String)"active", (boolean)source.isActive()));
            elem.addContent((Content)sourceElem);
        }
        return elem;
    }

    protected void restoreSourcesFromXml(Element elem, List<SourceState<?>> sources) {
        List sourceElems = elem.getChildren(VIEWERSTATE_SOURCE_TAG);
        if (sources.size() != sourceElems.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sources.size(); ++i) {
            sources.get(i).setActive(XmlHelpers.getBoolean((Element)((Element)sourceElems.get(i)), (String)"active"));
        }
    }

    public Element sourceGroupsToXml(List<bdv.viewer.state.SourceGroup> groups) {
        Element elem = new Element(VIEWERSTATE_GROUPS_TAG);
        for (bdv.viewer.state.SourceGroup group : groups) {
            Element groupElem = new Element(VIEWERSTATE_GROUP_TAG);
            groupElem.addContent((Content)XmlHelpers.booleanElement((String)"active", (boolean)group.isActive()));
            groupElem.addContent((Content)XmlHelpers.textElement((String)VIEWERSTATE_GROUP_NAME_TAG, (String)group.getName()));
            Iterator iterator = group.getSourceIds().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                groupElem.addContent((Content)XmlHelpers.intElement((String)VIEWERSTATE_GROUP_SOURCEID_TAG, (int)id));
            }
            elem.addContent((Content)groupElem);
        }
        return elem;
    }

    public void restoreSourceGroupsFromXml(Element elem, ViewerState state) {
        List groupElems = elem.getChildren(VIEWERSTATE_GROUP_TAG);
        int ng = state.numSourceGroups();
        while (ng < groupElems.size()) {
            state.addGroup(new bdv.viewer.state.SourceGroup(String.format("tmp %d", ng++)));
        }
        while (ng > groupElems.size()) {
            state.removeGroup(--ng);
        }
        SynchronizedViewerState nstate = state.getState();
        for (int i = 0; i < groupElems.size(); ++i) {
            SourceGroup group = nstate.getGroups().get(i);
            Element groupElem = (Element)groupElems.get(i);
            nstate.setGroupActive(group, XmlHelpers.getBoolean((Element)groupElem, (String)"active"));
            nstate.setGroupName(group, groupElem.getChildText(VIEWERSTATE_GROUP_NAME_TAG));
            nstate.removeSourcesFromGroup(new ArrayList(nstate.getSourcesInGroup(group)), group);
            for (Element idElem : groupElem.getChildren(VIEWERSTATE_GROUP_SOURCEID_TAG)) {
                nstate.addSourceToGroup(nstate.getSources().get(Integer.parseInt(idElem.getText())), group);
            }
        }
    }

    protected Element displayModeToXml(DisplayMode mode) {
        switch (mode) {
            case GROUP: {
                return new Element(VIEWERSTATE_DISPLAYMODE_TAG).setText(VIEWERSTATE_DISPLAYMODE_VALUE_GROUP);
            }
            case FUSED: {
                return new Element(VIEWERSTATE_DISPLAYMODE_TAG).setText(VIEWERSTATE_DISPLAYMODE_VALUE_FUSED);
            }
            case FUSEDGROUP: {
                return new Element(VIEWERSTATE_DISPLAYMODE_TAG).setText(VIEWERSTATE_DISPLAYMODE_VALUE_FUSEDGROUP);
            }
        }
        return new Element(VIEWERSTATE_DISPLAYMODE_TAG).setText(VIEWERSTATE_DISPLAYMODE_VALUE_SINGLE);
    }

    protected DisplayMode displayModeFromXml(Element elem) {
        String t = elem.getTextTrim();
        if (VIEWERSTATE_DISPLAYMODE_VALUE_GROUP.equals(t)) {
            return DisplayMode.GROUP;
        }
        if (VIEWERSTATE_DISPLAYMODE_VALUE_FUSED.equals(t)) {
            return DisplayMode.FUSED;
        }
        if (VIEWERSTATE_DISPLAYMODE_VALUE_FUSEDGROUP.equals(t)) {
            return DisplayMode.FUSEDGROUP;
        }
        return DisplayMode.SINGLE;
    }

    protected Element interpolationModeToXml(Interpolation mode) {
        switch (mode) {
            case NLINEAR: {
                return new Element(VIEWERSTATE_INTERPOLATION_TAG).setText(VIEWERSTATE_INTERPOLATION_VALUE_NLINEAR);
            }
        }
        return new Element(VIEWERSTATE_INTERPOLATION_TAG).setText(VIEWERSTATE_INTERPOLATION_VALUE_NEARESTNEIGHBOR);
    }

    protected Interpolation interpolationModeFromXml(Element elem) {
        String t = elem.getTextTrim();
        if (VIEWERSTATE_INTERPOLATION_VALUE_NLINEAR.equals(t)) {
            return Interpolation.NLINEAR;
        }
        return Interpolation.NEARESTNEIGHBOR;
    }
}

