/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.scijava.table.Column;
import org.scijava.table.SimpleCollections;
import org.scijava.table.Tables;

public interface Table<C extends Column<? extends T>, T>
extends List<C> {
    default public int getColumnCount() {
        return this.size();
    }

    public void setColumnCount(int var1);

    default public C get(String colHeader) {
        return (C)this.get(Tables.colIndex(this, colHeader));
    }

    default public C appendColumn() {
        return this.appendColumn(null);
    }

    default public C appendColumn(String colHeader) {
        return this.insertColumn(this.getColumnCount(), colHeader);
    }

    default public List<C> appendColumns(int count) {
        ArrayList<C> result = new ArrayList<C>(count);
        for (int c = 0; c < count; ++c) {
            result.add(this.appendColumn());
        }
        return result;
    }

    default public List<C> appendColumns(String ... colHeaders) {
        ArrayList<C> result = new ArrayList<C>(colHeaders.length);
        for (String colHeader : colHeaders) {
            result.add(this.appendColumn(colHeader));
        }
        return result;
    }

    default public C insertColumn(int col) {
        return this.insertColumn(col, null);
    }

    default public C insertColumn(int col, String colHeader) {
        List<C> result = this.insertColumns(col, 1);
        this.setColumnHeader(col, colHeader);
        return (C)((Column)result.get(0));
    }

    public List<C> insertColumns(int var1, int var2);

    default public List<C> insertColumns(int col, String ... headers) {
        List<C> result = this.insertColumns(col, headers.length);
        for (int c = 0; c < headers.length; ++c) {
            this.setColumnHeader(col + c, headers[c]);
        }
        return result;
    }

    default public C removeColumn(int col) {
        return (C)this.remove(col);
    }

    default public C removeColumn(String colHeader) {
        return this.removeColumn(Tables.colIndex(this, colHeader));
    }

    default public List<C> removeColumns(int col, int count) {
        Tables.checkCol(this, col, count);
        ArrayList<Object> result = new ArrayList<Object>(count);
        for (int c = 0; c < count; ++c) {
            result.add(this.get(col + c));
        }
        int oldColCount = this.getColumnCount();
        int newColCount = oldColCount - count;
        for (int oldC = col + count; oldC < oldColCount; ++oldC) {
            int newC = oldC - count;
            this.set(newC, (C)this.get(oldC));
        }
        this.setColumnCount(newColCount);
        return result;
    }

    default public List<C> removeColumns(String ... colHeaders) {
        ArrayList<C> result = new ArrayList<C>(colHeaders.length);
        for (String colHeader : colHeaders) {
            result.add(this.removeColumn(colHeader));
        }
        return result;
    }

    public int getRowCount();

    public void setRowCount(int var1);

    default public void appendRow() {
        this.appendRow(null);
    }

    default public void appendRow(String header) {
        this.insertRow(this.getRowCount(), header);
    }

    default public void appendRows(int count) {
        for (int c = 0; c < count; ++c) {
            this.appendRow();
        }
    }

    default public void appendRows(String ... headers) {
        for (String header : headers) {
            this.appendRow(header);
        }
    }

    default public void insertRow(int row) {
        this.insertRow(row, null);
    }

    default public void insertRow(int row, String header) {
        this.insertRows(row, 1);
        this.setRowHeader(row, header);
    }

    default public void insertRows(int row, int count) {
        int r;
        int newR;
        int oldR;
        Tables.checkRow(this, row, 0);
        int oldRowCount = this.getRowCount();
        int newRowCount = oldRowCount + count;
        this.setRowCount(newRowCount);
        for (oldR = oldRowCount - 1; oldR >= row; --oldR) {
            newR = oldR + count;
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.set(c, newR, this.get(c, oldR));
            }
        }
        for (oldR = oldRowCount - 1; oldR >= row; --oldR) {
            newR = oldR + count;
            this.setRowHeader(newR, this.getRowHeader(oldR));
        }
        for (r = 0; r < count; ++r) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.set(c, row + r, null);
            }
        }
        for (r = 0; r < count; ++r) {
            this.setRowHeader(row + r, null);
        }
    }

    default public void insertRows(int row, String ... headers) {
        this.insertRows(row, headers.length);
        for (int r = 0; r < headers.length; ++r) {
            this.setRowHeader(row + r, headers[r]);
        }
    }

    default public void removeRow(int row) {
        this.removeRows(row, 1);
    }

    default public void removeRow(String header) {
        int row = this.getColumnIndex(header);
        if (row < 0) {
            throw new IndexOutOfBoundsException("No such row: " + header);
        }
        this.removeRow(row);
    }

    public void removeRows(int var1, int var2);

    default public void removeRows(String ... headers) {
        for (String header : headers) {
            this.removeRow(header);
        }
    }

    default public void setDimensions(int colCount, int rowCount) {
        this.setColumnCount(colCount);
        this.setRowCount(rowCount);
    }

    default public String getColumnHeader(int col) {
        return this.get(col).getHeader();
    }

    default public void setColumnHeader(int col, String colHeader) {
        this.get(col).setHeader(colHeader);
    }

    default public int getColumnIndex(String colHeader) {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            String h = this.getColumnHeader(c);
            if (!Objects.equals(h, colHeader)) continue;
            return c;
        }
        return -1;
    }

    public String getRowHeader(int var1);

    public void setRowHeader(int var1, String var2);

    default public int getRowIndex(String header) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            String h = this.getRowHeader(r);
            if (!Objects.equals(h, header)) continue;
            return r;
        }
        return -1;
    }

    default public void set(int col, int row, T value) {
        Tables.checkCol(this, col, 1);
        Tables.checkRow(this, row, 1);
        Tables.assign(this.get(col), row, value);
    }

    public void set(String var1, int var2, T var3);

    default public T get(int col, int row) {
        Tables.checkCol(this, col, 1);
        Tables.checkRow(this, row, 1);
        return (T)this.get(col).get(row);
    }

    default public T get(String colHeader, int row) {
        int col = Tables.colIndex(this, colHeader);
        Tables.checkRow(this, row, 1);
        return (T)this.get(col).get(row);
    }

    @Override
    public int size();

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean contains(Object column) {
        return this.indexOf(column) >= 0;
    }

    @Override
    default public Iterator<C> iterator() {
        return this.listIterator();
    }

    @Override
    default public Object[] toArray() {
        return SimpleCollections.toArray(this);
    }

    @Override
    default public <A> A[] toArray(A[] a) {
        return SimpleCollections.toArray(this, a);
    }

    @Override
    default public boolean add(C column) {
        return SimpleCollections.add(this, column);
    }

    @Override
    default public boolean remove(Object column) {
        return SimpleCollections.remove(this, column);
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        return SimpleCollections.containsAll(this, c);
    }

    @Override
    default public boolean addAll(Collection<? extends C> c) {
        return SimpleCollections.addAll(this, c);
    }

    @Override
    default public boolean addAll(int col, Collection<? extends C> c) {
        return SimpleCollections.addAll(this, col, c);
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        return SimpleCollections.removeAll(this, c);
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        return SimpleCollections.retainAll(this, c);
    }

    @Override
    public void clear();

    @Override
    public C get(int var1);

    @Override
    public C set(int var1, C var2);

    @Override
    public void add(int var1, C var2);

    @Override
    public C remove(int var1);

    @Override
    default public int indexOf(Object column) {
        return SimpleCollections.indexOf(this, column);
    }

    @Override
    default public int lastIndexOf(Object column) {
        return SimpleCollections.lastIndexOf(this, column);
    }

    @Override
    default public ListIterator<C> listIterator() {
        return this.listIterator(0);
    }

    @Override
    default public ListIterator<C> listIterator(int col) {
        return SimpleCollections.listIterator(this, col);
    }

    @Override
    default public List<C> subList(int fromCol, int toCol) {
        return SimpleCollections.subList(this, fromCol, toCol);
    }
}

