/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.quantization;

import io.scif.jj2000.j2k.ModuleSpec;
import io.scif.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;

public class QuantTypeSpec
extends ModuleSpec {
    public QuantTypeSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public QuantTypeSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        if (values == null) {
            if (wp.getLossless()) {
                this.setDefault("reversible");
            } else {
                this.setDefault("expounded");
            }
            return;
        }
        this.specified = values;
        String param = values;
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecValType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        block10: while (stk.hasMoreTokens()) {
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = QuantTypeSpec.parseIdx(word, this.nTiles);
                    if (curSpecValType == 1) {
                        curSpecValType = 3;
                        continue block10;
                    }
                    curSpecValType = 2;
                    continue block10;
                }
                case 'c': {
                    compSpec = QuantTypeSpec.parseIdx(word, this.nComp);
                    if (curSpecValType == 2) {
                        curSpecValType = 3;
                        continue block10;
                    }
                    curSpecValType = 1;
                    continue block10;
                }
                case 'd': 
                case 'e': 
                case 'r': {
                    int i;
                    if (!(word.equalsIgnoreCase("reversible") || word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
                    }
                    if (wp.getLossless() && (word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Cannot use non reversible quantization with '-lossless' option");
                    }
                    if (curSpecValType == 0) {
                        this.setDefault(word);
                    } else if (curSpecValType == 2) {
                        for (i = tileSpec.length - 1; i >= 0; --i) {
                            if (!tileSpec[i]) continue;
                            this.setTileDef(i, word);
                        }
                    } else if (curSpecValType == 1) {
                        for (i = compSpec.length - 1; i >= 0; --i) {
                            if (!compSpec[i]) continue;
                            this.setCompDef(i, word);
                        }
                    } else {
                        for (i = tileSpec.length - 1; i >= 0; --i) {
                            for (int j = compSpec.length - 1; j >= 0; --j) {
                                if (!tileSpec[i] || !compSpec[j]) continue;
                                this.setTileCompVal(i, j, word);
                            }
                        }
                    }
                    curSpecValType = 0;
                    tileSpec = null;
                    compSpec = null;
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
        }
        if (this.getDefault() == null) {
            int t;
            int ndefspec = 0;
            for (t = nt - 1; t >= 0; --t) {
                for (int c = nc - 1; c >= 0; --c) {
                    if (this.specValType[t][c] != 0) continue;
                    ++ndefspec;
                }
            }
            if (ndefspec != 0) {
                if (wp.getLossless()) {
                    this.setDefault("reversible");
                } else {
                    this.setDefault("expounded");
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (int c = nc - 1; c >= 0; --c) {
                            if (this.specValType[0][c] != 2) continue;
                            this.specValType[0][c] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (t = nt - 1; t >= 0; --t) {
                            if (this.specValType[t][0] != 1) continue;
                            this.specValType[t][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    public boolean isDerived(int t, int c) {
        return ((String)this.getTileCompVal(t, c)).equals("derived");
    }

    public boolean isReversible(int t, int c) {
        return ((String)this.getTileCompVal(t, c)).equals("reversible");
    }

    public boolean isFullyReversible() {
        if (((String)this.getDefault()).equals("reversible")) {
            for (int t = this.nTiles - 1; t >= 0; --t) {
                for (int c = this.nComp - 1; c >= 0; --c) {
                    if (this.specValType[t][c] == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isFullyNonReversible() {
        for (int t = this.nTiles - 1; t >= 0; --t) {
            for (int c = this.nComp - 1; c >= 0; --c) {
                if (!((String)this.getSpec(t, c)).equals("reversible")) continue;
                return false;
            }
        }
        return true;
    }
}

