/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.container;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class ContainerMetadataWriter {
    private N5Writer n5;
    private ContainerMetadataNode metadataTree;

    public ContainerMetadataWriter(N5Writer n5, String dataset) {
        this(n5, ContainerMetadataNode.build((N5Reader)n5, dataset, JqUtils.buildGson((N5Reader)n5)));
    }

    public ContainerMetadataWriter(N5Writer n5) {
        this(n5, "");
    }

    public ContainerMetadataWriter(N5Writer n5, ContainerMetadataNode metadataTree) {
        this.n5 = n5;
        this.metadataTree = metadataTree;
    }

    public ContainerMetadataNode getMetadataTree() {
        return this.metadataTree;
    }

    public void setMetadataTree(ContainerMetadataNode metadataTree) {
        this.metadataTree = metadataTree;
    }

    public void setN5Writer(N5Writer n5) {
        this.n5 = n5;
    }

    public void writeAllAttributes() {
        Iterator it = this.metadataTree.getChildPathsRecursive(this.metadataTree.getPath()).iterator();
        while (it.hasNext()) {
            this.writeAllAttributes((String)it.next());
        }
    }

    public void writeAllAttributes(String pathName) {
        Optional<ContainerMetadataNode> nopt;
        if (!this.n5.exists(pathName)) {
            this.n5.createGroup(pathName);
        }
        if (!(nopt = this.metadataTree.getNode(pathName)).isPresent()) {
            return;
        }
        String path = nopt.get().getPath();
        HashMap<String, JsonElement> attrs = nopt.get().getContainerAttributes();
        for (String key : attrs.keySet()) {
            if (!attrs.containsKey(key)) continue;
            this.n5.setAttribute(path, key, (Object)attrs.get(key));
        }
    }

    public void writeAttribute(String pathName, String key) throws IOException {
        Optional<ContainerMetadataNode> nopt = this.metadataTree.getChild(pathName, "/");
        if (!nopt.isPresent()) {
            return;
        }
        HashMap<String, JsonElement> attrs = nopt.get().getContainerAttributes();
        if (attrs.containsKey(key)) {
            this.n5.setAttribute(pathName, key, (Object)attrs.get(key));
        }
    }
}

