/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axes;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;

public class IndexedAxis
extends Axis {
    private int index;

    public IndexedAxis(String type, String label, String unit, int index) {
        super(type, label, unit);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setDefaults(boolean data, int idx) {
        this.setDefaultIndex(idx);
        this.setDefaultUnit();
        this.setDefaultLabel(data);
        this.setDefaultType();
    }

    protected void setDefaultIndex(int idx) {
        if (this.index < 0) {
            this.index = idx;
        }
    }

    protected void setDefaultLabel(boolean data) {
        if (this.name == null) {
            this.name = data ? String.format("data_%d", this.index) : String.format("dim_%d", this.index);
        }
    }

    protected void setDefaultType() {
        if (this.type == null) {
            this.type = AxisUtils.getDefaultType(this.name);
        }
    }

    protected void setDefaultUnit() {
        if (this.unit == null) {
            this.unit = "none";
        }
    }

    public static IndexedAxis[] axesFromLabels(String[] labels, String[] units, int[] indexes) {
        String[] types = AxisUtils.getDefaultTypes(labels);
        int N = labels.length;
        IndexedAxis[] axesIdx = new IndexedAxis[N];
        for (int i = 0; i < N; ++i) {
            axesIdx[i] = new IndexedAxis(types[i], labels[i], units[i], indexes[i]);
        }
        return axesIdx;
    }

    public static IndexedAxis[] axesFromLabels(String[] labels, String unitIn) {
        String unit = unitIn == null ? "none" : unitIn;
        Object[] units = new String[labels.length];
        Arrays.fill(units, unit);
        return IndexedAxis.axesFromLabels(labels, (String[])units, IntStream.range(0, labels.length).toArray());
    }

    public static IndexedAxis[] axesFromLabels(String[] labels, int[] indexes, String unitIn) {
        String unit = unitIn == null ? "none" : unitIn;
        Object[] units = new String[labels.length];
        Arrays.fill(units, unit);
        return IndexedAxis.axesFromLabels(labels, (String[])units, indexes);
    }

    public static IndexedAxis[] axesFromLabels(String ... labels) {
        return IndexedAxis.axesFromLabels(labels, "none");
    }

    public static IndexedAxis[] defaultAxes(int N) {
        return IndexedAxis.defaultAxes(N, "none");
    }

    public static IndexedAxis[] defaultAxes(int N, int firstIndex) {
        return IndexedAxis.defaultAxes(N, firstIndex, "none");
    }

    public static IndexedAxis[] defaultAxes(int N, String unit) {
        return IndexedAxis.defaultAxes(N, 0, unit);
    }

    public static IndexedAxis[] defaultAxes(int N, int firstIndex, String unit) {
        return (IndexedAxis[])IntStream.range(0, N).mapToObj(i -> IndexedAxis.defaultAxis(firstIndex + i, unit)).toArray(IndexedAxis[]::new);
    }

    public static IndexedAxis defaultAxis(int i, String unit) {
        return new IndexedAxis("unknown", Integer.toString(i), unit, i);
    }

    public static IndexedAxis[] axesFromIndexes(int[] indexes) {
        return (IndexedAxis[])Arrays.stream(indexes).mapToObj(i -> IndexedAxis.defaultAxis(i, "none")).toArray(IndexedAxis[]::new);
    }

    public static IndexedAxis[] axesFromIndexes(int[] indexes, String unit) {
        return (IndexedAxis[])Arrays.stream(indexes).mapToObj(i -> IndexedAxis.defaultAxis(i, unit)).toArray(IndexedAxis[]::new);
    }

    public static IndexedAxis[] dataAxes(int[] indexes) {
        return (IndexedAxis[])Arrays.stream(indexes).mapToObj(i -> IndexedAxis.dataAxis(i)).toArray(IndexedAxis[]::new);
    }

    public static IndexedAxis[] dataAxes(int N, int firstIndex) {
        return (IndexedAxis[])IntStream.range(0, N).mapToObj(i -> IndexedAxis.dataAxis(firstIndex + i)).toArray(IndexedAxis[]::new);
    }

    public static IndexedAxis[] dataAxes(int N) {
        return IndexedAxis.dataAxes(N, 0);
    }

    public static IndexedAxis[] dataAxesStartEnd(int start, int endInclusive) {
        return (IndexedAxis[])IntStream.rangeClosed(start, endInclusive).mapToObj(i -> IndexedAxis.dataAxis(i)).toArray(IndexedAxis[]::new);
    }

    public static IndexedAxis dataAxis(int i) {
        return new IndexedAxis("data", String.format("data_%d", i), "none", i);
    }
}

