/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.axisTransforms;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import net.imglib2.realtransform.RealTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.IndexedAxis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.IndexedAxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.IdentitySpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.ScaleSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class TransformAxes
implements SpatialTransform,
IndexedAxisMetadata {
    private SpatialTransform transform;
    private IndexedAxis[] inputAxes;
    private IndexedAxis[] outputAxes;

    public TransformAxes(SpatialTransform transform, IndexedAxis[] inputAxes, IndexedAxis[] outputAxes) {
        this.transform = transform;
        this.inputAxes = inputAxes;
        this.outputAxes = outputAxes;
    }

    public TransformAxes(SpatialTransform transform, String ... labels) {
        this(transform, IndexedAxis.dataAxes(labels.length), IndexedAxis.axesFromLabels(labels));
    }

    public TransformAxes(int[] indexes, String ... labels) {
        this((SpatialTransform)new IdentitySpatialTransform(), IndexedAxis.dataAxes(labels.length), IndexedAxis.axesFromLabels(labels, indexes, "none"));
    }

    public TransformAxes(String ... labels) {
        this((SpatialTransform)new IdentitySpatialTransform(), IndexedAxis.dataAxes(labels.length), IndexedAxis.axesFromLabels(labels, "none"));
    }

    protected void setDefaults(int firstIndex) {
        int nd = -1;
        if (this.transform != null) {
            nd = this.transform.getTransform().numSourceDimensions();
        }
        if (nd < 1 && this.outputAxes != null) {
            nd = this.outputAxes.length;
        } else if (nd < 1 && this.inputAxes != null) {
            nd = this.inputAxes.length;
        }
        if (this.transform == null) {
            this.transform = new IdentitySpatialTransform();
        }
        if (this.inputAxes == null) {
            this.inputAxes = IndexedAxis.dataAxes(nd, firstIndex);
        }
        if (this.outputAxes == null) {
            this.outputAxes = IndexedAxis.defaultAxes(nd, firstIndex);
        }
        int i = firstIndex;
        for (IndexedAxis ia : this.inputAxes) {
            ia.setDefaults(true, i++);
        }
        i = firstIndex;
        for (IndexedAxis oa : this.outputAxes) {
            oa.setDefaults(false, i++);
        }
    }

    public IndexedAxis[] getInputAxes() {
        return this.inputAxes;
    }

    public IndexedAxis[] getOutputAxes() {
        return this.outputAxes;
    }

    @Override
    public Axis[] getAxes() {
        return this.getOutputAxes();
    }

    @Override
    public int[] getIndexes() {
        return Arrays.stream(this.outputAxes).mapToInt(IndexedAxis::getIndex).toArray();
    }

    @Override
    public RealTransform getTransform() {
        return this.transform.getTransform();
    }

    public static void main(String[] args) throws JsonSyntaxException, JsonIOException, FileNotFoundException {
        Gson gson = JqUtils.buildGson(null);
        ScaleSpatialTransform xfm = new ScaleSpatialTransform(new double[]{2.0, 3.0, 4.0});
        File f = new File("/home/john/dev/n5/n5-imglib2-translation/src/test/resources/transforms/transformsWithAxes.json");
        TransformAxes tam = (TransformAxes)gson.fromJson((Reader)new FileReader(f), TransformAxes.class);
        System.out.println(tam);
    }
}

