/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.translation;

import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataWriter;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;
import org.janelia.saalfeldlab.n5.universe.translation.TreeTranslation;

public class TranslatedMetadataWriter<T extends N5Metadata>
extends TreeTranslation
implements N5MetadataWriter<T> {
    private N5Writer n5;
    private ContainerMetadataWriter containerWriter;
    private final N5MetadataWriter<T> metaWriter;

    public TranslatedMetadataWriter(N5Writer n5, String dataset, String translation, N5MetadataWriter<T> metaWriter) {
        super(ContainerMetadataNode.build((N5Reader)n5, dataset, JqUtils.buildGson((N5Reader)n5)), JqUtils.buildGson((N5Reader)n5), translation);
        this.n5 = n5;
        this.metaWriter = metaWriter;
        this.containerWriter = new ContainerMetadataWriter(n5, this.rootTranslated);
    }

    public TranslatedMetadataWriter(N5Writer n5, String translation, N5MetadataWriter<T> metaWriter) {
        this(n5, "", translation, metaWriter);
    }

    @Override
    public void writeMetadata(T t, N5Writer n5, String path) throws Exception {
        this.n5 = n5;
        this.metaWriter.writeMetadata(t, (N5Writer)this.getOrig(), path);
        this.updateTranslated();
        this.containerWriter.setN5Writer(n5);
        this.containerWriter.setMetadataTree(this.rootTranslated);
        this.containerWriter.writeAllAttributes();
    }
}

