/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.frame.PlugInFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class Sync_Windows
extends PlugInFrame
implements ActionListener,
MouseMotionListener,
MouseListener,
DisplayChangeListener,
ItemListener,
ImageListener {
    protected static final String VERSIONSTRING = "1.7-fiji1";
    protected Vector vwins = null;
    protected int oldX;
    protected int oldY;
    protected int x = 0;
    protected int y = 0;
    protected List wList;
    protected Panel panel;
    protected Checkbox cCursor;
    protected Checkbox cSlice;
    protected Checkbox cChannel;
    protected Checkbox cFrame;
    protected Checkbox cCoords;
    protected Checkbox cScaling;
    protected Button bSyncAll;
    protected Button bUnsyncAll;
    protected Vector vListMap;
    protected final ImageJ ijInstance;
    private double currentMag = 1.0;
    private Rectangle currentSrcRect = new Rectangle(0, 0, 400, 400);
    static final int RSZ = 16;
    static final int SZ = 8;
    static final int SCALE = 3;
    boolean bImage5DInstalled = true;

    public Sync_Windows() {
        this("Sync Windows 1.7-fiji1");
    }

    public Sync_Windows(String s) {
        super(s);
        try {
            Class.forName("i5d.gui.Image5DWindow");
        }
        catch (ClassNotFoundException e1) {
            this.bImage5DInstalled = false;
        }
        if (!this.bImage5DInstalled) {
            try {
                Class.forName("Image5DWindow");
                IJ.log((String)"An old version of Image5D is installed.\nSyncWindows will not work with Image5Ds of this version.\nUpdate to Image5D version 1.1.6 or higher.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.panel = this.controlPanel();
        this.add(this.panel);
        this.pack();
        this.setResizable(false);
        this.ijInstance = IJ.getInstance();
        IJ.register(this.getClass());
    }

    public void run(String args) {
        if (IJ.versionLessThan((String)"1.37b")) {
            return;
        }
        if (args.equals("about")) {
            this.showAbout();
            return;
        }
        this.updateWindowList();
        WindowManager.addWindow((Frame)((Object)this));
        ImagePlus.addImageListener((ImageListener)this);
        this.show();
    }

    @Override
    public void displayChanged(DisplayChangeEvent e) {
        ImageWindow iw;
        ImagePlus imp;
        int n;
        if (this.vwins == null) {
            return;
        }
        Object source = e.getSource();
        int type = e.getType();
        int value = e.getValue();
        ImageWindow iwc = WindowManager.getCurrentImage().getWindow();
        if (!iwc.equals(source)) {
            return;
        }
        if (this.cSlice.getState() && type == 3) {
            for (n = 0; n < this.vwins.size(); ++n) {
                imp = this.getImageFromVector(n);
                if (imp == null) continue;
                iw = imp.getWindow();
                int stacksize = imp.getStackSize();
                if (iw.equals(source) || !(iw instanceof StackWindow)) continue;
                ((StackWindow)iw).setPosition(imp.getChannel(), value, imp.getFrame());
            }
        }
        if (this.cChannel.getState() && type == 6) {
            for (n = 0; n < this.vwins.size(); ++n) {
                imp = this.getImageFromVector(n);
                if (imp == null || (iw = imp.getWindow()).equals(source)) continue;
                if (this.bImage5DInstalled && OpenImage5DAdapter.isImage5DWindow(iw)) {
                    OpenImage5DAdapter.setChannel(imp, value);
                    continue;
                }
                if (!(iw instanceof StackWindow)) continue;
                ((StackWindow)iw).setPosition(value, imp.getSlice(), imp.getFrame());
            }
        }
        if (this.bImage5DInstalled && this.cFrame.getState() && type == 5) {
            for (n = 0; n < this.vwins.size(); ++n) {
                imp = this.getImageFromVector(n);
                if (imp == null || (iw = imp.getWindow()).equals(source)) continue;
                if (this.bImage5DInstalled && OpenImage5DAdapter.isImage5DWindow(iw)) {
                    OpenImage5DAdapter.setFrame(imp, value);
                    continue;
                }
                if (!(iw instanceof StackWindow)) continue;
                ((StackWindow)iw).setPosition(imp.getChannel(), imp.getSlice(), value);
            }
        }
        ImageCanvas icc = iwc.getCanvas();
        this.storeCanvasState(icc);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.x = e.getX();
        this.y = e.getY();
        Point p = new Point(this.x, this.y);
        Rectangle rect = this.boundingRect(this.x, this.y, this.oldX, this.oldY);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null) continue;
            ImageWindow iw = imp.getWindow();
            ImageCanvas ic = iw.getCanvas();
            if (this.cCoords.getState() && iw != iwc) {
                p = this.getMatchingCoords(ic, icc, this.x, this.y);
                Point oldp = this.getMatchingCoords(ic, icc, this.oldX, this.oldY);
                rect = this.boundingRect(p.x, p.y, oldp.x, oldp.y);
            } else {
                p.x = this.x;
                p.y = this.y;
                rect = this.boundingRect(this.x, this.y, this.oldX, this.oldY);
            }
            Roi roi = imp.getRoi();
            if (roi == null || !(roi instanceof PolygonRoi) || roi.getState() != 0) {
                this.drawSyncCursor(ic, rect, p.x, p.y);
            }
            if (iw == iwc) continue;
            ic.mouseMoved(this.adaptEvent(e, (Canvas)ic, p));
        }
        iwc.getImagePlus().mouseMoved(icc.offScreenX(this.x), icc.offScreenY(this.y));
        this.storeCanvasState(icc);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.x = e.getX();
        this.y = e.getY();
        Point p = new Point(this.x, this.y);
        Rectangle rect = this.boundingRect(this.x, this.y, this.oldX, this.oldY);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null) continue;
            ImageWindow iw = imp.getWindow();
            ImageCanvas ic = iw.getCanvas();
            if (this.cCoords.getState() && iw != iwc) {
                p = this.getMatchingCoords(ic, icc, this.x, this.y);
                Point oldp = this.getMatchingCoords(ic, icc, this.oldX, this.oldY);
                rect = this.boundingRect(p.x, p.y, oldp.x, oldp.y);
            } else {
                p = new Point(this.x, this.y);
                rect = this.boundingRect(this.x, this.y, this.oldX, this.oldY);
            }
            Roi roi = imp.getRoi();
            if (roi == null || !(roi instanceof PolygonRoi) || roi.getState() != 0) {
                this.drawSyncCursor(ic, rect, p.x, p.y);
            }
            if (iw == iwc) continue;
            ic.mouseDragged(this.adaptEvent(e, (Canvas)ic, p));
        }
        this.storeCanvasState(icc);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        if (Toolbar.getToolId() != 11 && (e.isPopupTrigger() || (e.getModifiers() & 4) != 0)) {
            return;
        }
        Point p = new Point(this.x, this.y);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            ImageWindow iw;
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null || (iw = imp.getWindow()) == iwc) continue;
            ImageCanvas ic = iw.getCanvas();
            if (this.cCoords.getState()) {
                p = this.getMatchingCoords(ic, icc, this.x, this.y);
            }
            ic.mouseClicked(this.adaptEvent(e, (Canvas)ic, p));
        }
        this.storeCanvasState(icc);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        Point p = new Point(this.x, this.y);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            ImageWindow iw;
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null || (iw = imp.getWindow()) == iwc) continue;
            ImageCanvas ic = iw.getCanvas();
            if (this.cCoords.getState()) {
                p = this.getMatchingCoords(ic, icc, this.x, this.y);
            }
            ic.mouseEntered(this.adaptEvent(e, (Canvas)ic, p));
        }
        this.storeCanvasState(icc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        Point p = new Point(this.x, this.y);
        Rectangle rect = this.boundingRect(this.x, this.y, this.x, this.y);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null) continue;
            ImageWindow iw = imp.getWindow();
            ImageCanvas ic = iw.getCanvas();
            if (this.cCoords.getState() && iw != iwc) {
                p = this.getMatchingCoords(ic, icc, this.x, this.y);
                rect = this.boundingRect(p.x, p.y, p.x, p.y);
            } else {
                p.x = this.x;
                p.y = this.y;
                rect = this.boundingRect(this.x, this.y, this.x, this.y);
            }
            Graphics g = ic.getGraphics();
            try {
                g.setClip(rect.x, rect.y, rect.width, rect.height);
                ic.paint(g);
            }
            finally {
                g.dispose();
            }
            if (iw == iwc) continue;
            ic.mouseExited(this.adaptEvent(e, (Canvas)ic, p));
        }
        this.storeCanvasState(icc);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        if (Toolbar.getToolId() != 11 && (e.isPopupTrigger() || (e.getModifiers() & 4) != 0)) {
            return;
        }
        Point p = new Point(this.x, this.y);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null) continue;
            ImageWindow iw = imp.getWindow();
            ImageCanvas ic = iw.getCanvas();
            ic.paint(ic.getGraphics());
            if (iw == iwc) continue;
            ic = iw.getCanvas();
            if (this.cCoords.getState()) {
                p = this.getMatchingCoords(ic, icc, this.x, this.y);
            }
            ic.mousePressed(this.adaptEvent(e, (Canvas)ic, p));
        }
        this.storeCanvasState(icc);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.cCursor.getState()) {
            return;
        }
        if (this.vwins == null) {
            return;
        }
        if (Toolbar.getToolId() != 11 && (e.isPopupTrigger() || (e.getModifiers() & 4) != 0)) {
            return;
        }
        int xloc = e.getX();
        int yloc = e.getY();
        Point p = new Point(xloc, yloc);
        Rectangle rect = this.boundingRect(xloc, yloc, xloc, yloc);
        ImageCanvas icc = (ImageCanvas)e.getSource();
        ImageWindow iwc = (ImageWindow)icc.getParent();
        for (int n = 0; n < this.vwins.size(); ++n) {
            Roi roi;
            if (this.ijInstance.quitting()) {
                return;
            }
            ImagePlus imp = this.getImageFromVector(n);
            if (imp == null) continue;
            ImageWindow iw = imp.getWindow();
            ImageCanvas ic = iw.getCanvas();
            if (this.cCoords.getState()) {
                p = this.getMatchingCoords(ic, icc, xloc, yloc);
                rect = this.boundingRect(p.x, p.y, p.x, p.y);
            }
            if ((roi = imp.getRoi()) == null || !(roi instanceof PolygonRoi) || roi.getState() != 0) {
                this.drawSyncCursor(ic, rect, p.x, p.y);
            }
            if (iw == iwc) continue;
            ic.mouseReleased(this.adaptEvent(e, (Canvas)ic, p));
        }
        this.storeCanvasState(icc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof Button) {
            Button bpressed = (Button)source;
            if (bpressed == this.bSyncAll) {
                if (this.wList == null) {
                    return;
                }
                Vector<Integer> v = new Vector<Integer>();
                for (int i = 0; i < this.wList.getItemCount(); ++i) {
                    this.wList.select(i);
                    Integer I = (Integer)this.vListMap.elementAt(i);
                    v.addElement(I);
                }
                this.addWindows(v);
            } else if (bpressed == this.bUnsyncAll) {
                this.removeAllWindows();
            }
        } else if (this.wList != null && source == this.wList) {
            this.addSelections();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.wList != null && e.getSource() == this.wList) {
            if (this.vwins != null) {
                for (int n = 0; n < this.vwins.size(); ++n) {
                    Integer I = (Integer)this.vwins.elementAt(n);
                    this.removeWindow(I);
                }
                this.vwins.removeAllElements();
            }
            this.addSelections();
        }
        if (this.cCoords != null && e.getSource() == this.cCoords && this.cScaling != null && e.getStateChange() == 2) {
            this.cScaling.setState(false);
        }
        if (this.cScaling != null && e.getSource() == this.cScaling && this.cCoords != null && e.getStateChange() == 1) {
            this.cCoords.setState(true);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.removeAllWindows();
            ImagePlus.removeImageListener((ImageListener)this);
            this.close();
        }
    }

    public void imageOpened(ImagePlus imp) {
        this.updateWindowList();
    }

    public void imageClosed(ImagePlus imp) {
        this.updateWindowList();
    }

    public void imageUpdated(ImagePlus imp) {
    }

    protected Panel controlPanel() {
        Panel p = new Panel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(3);
        p.setLayout(layout);
        p.add(this.buildWindowList(), "North", 0);
        p.add(this.buildControlPanel(), "Center", 1);
        return p;
    }

    protected Component buildWindowList() {
        int[] imageIDs = WindowManager.getIDList();
        if (imageIDs != null) {
            for (int n = 0; n < imageIDs.length; ++n) {
                ImagePlus img = WindowManager.getImage((int)imageIDs[n]);
                ImageWindow iw = img.getWindow();
                iw = this.bImage5DInstalled ? OpenImage5DAdapter.makeOpenWindow(iw) : OpenStackAdapter.makeOpenWindow(iw);
            }
        }
        if (imageIDs != null) {
            int n;
            int size = imageIDs.length < 10 ? imageIDs.length : 10;
            this.wList = new List(size, true);
            this.vListMap = new Vector();
            for (n = 0; n < imageIDs.length; ++n) {
                this.vListMap.addElement(new Integer(imageIDs[n]));
                this.wList.add(WindowManager.getImage((int)imageIDs[n]).getTitle());
                if (this.vwins == null || !this.vwins.contains(new Integer(imageIDs[n]))) continue;
                this.wList.select(n);
            }
            if (this.vwins != null && this.vwins.size() != 0) {
                for (n = 0; n < this.vwins.size(); ++n) {
                    if (this.vListMap.contains(this.vwins.elementAt(n))) continue;
                    this.vwins.removeElementAt(n);
                    --n;
                }
            }
            this.wList.addItemListener(this);
            this.wList.addActionListener(this);
            return this.wList;
        }
        Label label = new Label("No windows to select.");
        this.wList = null;
        this.vListMap = null;
        this.vwins = null;
        return label;
    }

    protected Panel buildControlPanel() {
        GridLayout layout = new GridLayout(4, 2);
        layout.setVgap(2);
        layout.setHgap(2);
        Panel p = new Panel(layout);
        this.cCursor = new Checkbox("Sync Cursor", true);
        p.add(this.cCursor);
        this.cSlice = new Checkbox("Sync z-Slices", true);
        p.add(this.cSlice);
        this.cChannel = new Checkbox("Sync Channels", true);
        p.add(this.cChannel);
        this.cFrame = new Checkbox("Sync t-Frames", true);
        p.add(this.cFrame);
        this.cCoords = new Checkbox("Image Coordinates", true);
        this.cCoords.addItemListener(this);
        p.add(this.cCoords);
        this.cScaling = new Checkbox("Image Scaling", false);
        this.cScaling.addItemListener(this);
        p.add(this.cScaling);
        this.bSyncAll = new Button("Synchronize All");
        this.bSyncAll.addActionListener(this);
        p.add(this.bSyncAll);
        this.bUnsyncAll = new Button("Unsynchronize All");
        this.bUnsyncAll.addActionListener(this);
        p.add(this.bUnsyncAll);
        return p;
    }

    protected Rectangle boundingRect(int x, int y, int oldX, int oldY) {
        int dx = Math.abs(oldX - x) / 2;
        int dy = Math.abs(oldY - y) / 2;
        int xOffset = dx + 24;
        int yOffset = dy + 24;
        int xCenter = (x + oldX) / 2;
        int yCenter = (y + oldY) / 2;
        int xOrg = Math.max(xCenter - xOffset, 0);
        int yOrg = Math.max(yCenter - yOffset, 0);
        int w = 2 * xOffset;
        int h = 2 * yOffset;
        return new Rectangle(xOrg, yOrg, w, h);
    }

    protected void updateWindowList() {
        Component newWindowList = this.buildWindowList();
        this.panel.remove(0);
        this.panel.add(newWindowList, "North", 0);
        this.pack();
    }

    private void addSelections() {
        if (this.wList == null) {
            return;
        }
        int[] listIndexes = this.wList.getSelectedIndexes();
        Vector<Integer> v = new Vector<Integer>();
        for (int n = 0; n < listIndexes.length; ++n) {
            Integer I = (Integer)this.vListMap.elementAt(listIndexes[n]);
            v.addElement(I);
        }
        this.addWindows(v);
    }

    private void addWindows(Vector v) {
        if (this.vwins == null && v.size() > 0) {
            this.vwins = new Vector();
        }
        for (int n = 0; n < v.size(); ++n) {
            ImagePlus imp;
            Integer I = (Integer)v.elementAt(n);
            if (this.vwins.contains(I) || (imp = WindowManager.getImage((int)I)) == null) continue;
            ImageWindow iw = imp.getWindow();
            iw.getCanvas().addMouseMotionListener((MouseMotionListener)this);
            iw.getCanvas().addMouseListener((MouseListener)this);
            if (this.bImage5DInstalled) {
                OpenImage5DAdapter.addDisplayChangeListener(iw, this);
            } else {
                OpenStackAdapter.addDisplayChangeListener(iw, this);
            }
            this.vwins.addElement(I);
        }
    }

    private void removeAllWindows() {
        if (this.vwins != null) {
            for (int n = 0; n < this.vwins.size(); ++n) {
                Integer I = (Integer)this.vwins.elementAt(n);
                this.removeWindow(I);
            }
            this.vwins.removeAllElements();
        }
        if (this.wList == null) {
            return;
        }
        for (int n = 0; n < this.wList.getItemCount(); ++n) {
            this.wList.deselect(n);
        }
    }

    private void removeWindow(Integer I) {
        ImageWindow iw;
        ImagePlus imp = WindowManager.getImage((int)I);
        if (imp != null && (iw = imp.getWindow()) != null) {
            if (this.bImage5DInstalled) {
                OpenImage5DAdapter.removeDisplayChangeListener(iw, this);
            } else {
                OpenStackAdapter.removeDisplayChangeListener(iw, this);
            }
            ImageCanvas ic = iw.getCanvas();
            if (ic != null) {
                ic.removeMouseListener((MouseListener)this);
                ic.removeMouseMotionListener((MouseMotionListener)this);
                ic.paint(ic.getGraphics());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSyncCursor(ImageCanvas ic, Rectangle rect, int x, int y) {
        int xpSZ = x + 8;
        int xmSZ = x - 8;
        int ypSZ = y + 8;
        int ymSZ = y - 8;
        int xp2 = x + 2;
        int xm2 = x - 2;
        int yp2 = y + 2;
        int ym2 = y - 2;
        Graphics g = ic.getGraphics();
        try {
            g.setClip(rect.x, rect.y, rect.width, rect.height);
            ic.paint(g);
            g.setColor(Color.red);
            g.drawLine(xmSZ, ymSZ, xm2, ym2);
            g.drawLine(xpSZ, ypSZ, xp2, yp2);
            g.drawLine(xpSZ, ymSZ, xp2, ym2);
            g.drawLine(xmSZ, ypSZ, xm2, yp2);
        }
        finally {
            g.dispose();
        }
    }

    private void storeCanvasState(ImageCanvas ic) {
        this.currentMag = ic.getMagnification();
        this.currentSrcRect = new Rectangle(ic.getSrcRect());
    }

    public ImagePlus getImageFromVector(int n) {
        if (this.vwins == null || n < 0 || this.vwins.size() < n + 1) {
            return null;
        }
        ImagePlus imp = WindowManager.getImage((int)((Integer)this.vwins.elementAt(n)));
        return imp;
    }

    public String getImageTitleFromVector(int n) {
        if (this.vwins == null || n < 0 || this.vwins.size() < n + 1) {
            return "";
        }
        ImagePlus imp = WindowManager.getImage((int)((Integer)this.vwins.elementAt(n)));
        String title = imp.getTitle();
        if (title.length() >= 4 && title.substring(title.length() - 4).equalsIgnoreCase(".tif")) {
            title = title.substring(0, title.length() - 4);
        } else if (title.length() >= 5 && title.substring(title.length() - 5).equalsIgnoreCase(".tiff")) {
            title = title.substring(0, title.length() - 5);
        }
        return title;
    }

    public int getIndexOfImage(ImagePlus image) {
        int index = -1;
        if (this.vwins == null || this.vwins.size() == 0) {
            return index;
        }
        for (int n = 0; n < this.vwins.size(); ++n) {
            ImagePlus imp = WindowManager.getImage((int)((Integer)this.vwins.elementAt(n)));
            if (imp != image) continue;
            index = n;
            break;
        }
        return index;
    }

    protected Point getMatchingCoords(ImageCanvas ic, ImageCanvas icc, int x, int y) {
        double xOffScreen = (double)this.currentSrcRect.x + (double)x / this.currentMag;
        double yOffScreen = (double)this.currentSrcRect.y + (double)y / this.currentMag;
        if (this.cScaling.getState()) {
            Calibration cal = ((ImageWindow)ic.getParent()).getImagePlus().getCalibration();
            Calibration curCal = ((ImageWindow)icc.getParent()).getImagePlus().getCalibration();
            xOffScreen = (xOffScreen - curCal.xOrigin) * curCal.pixelWidth / cal.pixelWidth + cal.xOrigin;
            yOffScreen = (yOffScreen - curCal.yOrigin) * curCal.pixelHeight / cal.pixelHeight + cal.yOrigin;
        }
        int xnew = ic.screenXD(xOffScreen);
        int ynew = ic.screenYD(yOffScreen);
        return new Point(xnew, ynew);
    }

    private MouseEvent adaptEvent(MouseEvent e, Canvas c, Point p) {
        return new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
    }

    protected void showAbout() {
        IJ.showMessage((String)"Sync Windows 1.7-fiji1", (String)"Synchronizes mouse movements, clicks and z-slices in the selected windows.\nHandy for viewing multichannel data as separate monochrome images.\n \nWritten by Patrick Kelly as part of the UCSD plugins.\nImproved GUI, support of image coordinates and z-slices by Joachim Walter.");
    }
}

