/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.platforms.windows;

import java.io.IOException;
import java.net.URL;
import org.scijava.platform.AbstractPlatform;
import org.scijava.platform.Platform;
import org.scijava.plugin.Plugin;

@Plugin(type=Platform.class, name="Windows")
public class WindowsPlatform
extends AbstractPlatform {
    public String osName() {
        return "Windows";
    }

    public void open(URL url) throws IOException {
        String arg;
        String cmd;
        if (System.getProperty("os.name").startsWith("Windows 2000")) {
            cmd = "rundll32";
            arg = "shell32.dll,ShellExec_RunDLL";
        } else {
            cmd = "rundll32";
            arg = "url.dll,FileProtocolHandler";
        }
        if (this.getPlatformService().exec(new String[]{cmd, arg, url.toString()}) != 0) {
            throw new IOException("Could not open " + url);
        }
    }
}

