/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;

public class LiICQ<T extends RealType<T>>
extends Algorithm<T> {
    double icqValue;

    public LiICQ() {
        super("Li ICQ calculation");
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        double mean1 = container.getMeanCh1();
        double mean2 = container.getMeanCh2();
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        this.icqValue = LiICQ.calculateLisICQ(cursor, mean1, mean2);
    }

    public static <T extends RealType<T>> double calculateLisICQ(TwinCursor<T> cursor, double mean1, double mean2) {
        long numPositiveProducts = 0L;
        long numNegativeProducts = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            RealType type1 = (RealType)cursor.getFirst();
            RealType type2 = (RealType)cursor.getSecond();
            double ch1 = type1.getRealDouble();
            double ch2 = type2.getRealDouble();
            double productOfDifferenceOfMeans = (mean1 - ch1) * (mean2 - ch2);
            if (productOfDifferenceOfMeans < 0.0) {
                ++numNegativeProducts;
                continue;
            }
            ++numPositiveProducts;
        }
        return (double)numPositiveProducts / (double)(numNegativeProducts + numPositiveProducts) - 0.5;
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleValue("Li's ICQ value", this.icqValue);
    }
}

