/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import ij.IJ;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.plugin.PlugIn;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class CPU_Meter
implements PlugIn {
    public void run(String arg) {
        new CPUMeter().start();
    }

    public class CPUMeter
    extends Thread {
        protected double[] avg = new double[3];
        protected double[] x;
        protected double[] y;
        protected long msecsBetweenUpdates;
        protected PlotWindow plotWindow;

        public CPUMeter() {
            this(50, IJ.isLinux() ? 5000L : 1000L);
        }

        public CPUMeter(int ticks, long msecsBetweenUpdates) {
            this.x = new double[ticks];
            this.y = new double[ticks];
            this.msecsBetweenUpdates = msecsBetweenUpdates;
            for (int i = 0; i < ticks; ++i) {
                this.x[ticks - 1 - i] = (double)((long)(-i) * msecsBetweenUpdates) / 1000.0;
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.update();
                    Thread.sleep(this.msecsBetweenUpdates);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }

        protected void update() {
            double load;
            System.arraycopy(this.y, 1, this.y, 0, this.y.length - 1);
            this.y[this.y.length - 1] = load = CLibrary.INSTANCE.getloadavg(this.avg, 1) == 1 ? this.avg[0] : 0.0;
            double yMin = this.y[0];
            double yMax = this.y[0];
            for (int i = 1; i < this.y.length; ++i) {
                if (yMin > this.y[i]) {
                    yMin = this.y[i];
                    continue;
                }
                if (!(yMax < this.y[i])) continue;
                yMax = this.y[i];
            }
            double delta = yMin == yMax ? 0.1 : (yMax - yMin) * 0.05;
            Plot plot = new Plot("CPU Meter", "seconds", "load", this.x, this.y);
            plot.setLimits(this.x[0], this.x[this.x.length - 1], yMin -= delta, yMax += delta);
            if (this.plotWindow == null) {
                this.plotWindow = plot.show();
                this.plotWindow.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        CPUMeter.this.interrupt();
                    }
                });
            } else {
                this.plotWindow.drawPlot(plot);
            }
        }
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.load((String)(Platform.isWindows() ? "msvcrt" : "c"), CLibrary.class);

        public int getloadavg(double[] var1, int var2);
    }
}

